/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.PipelineConfiguration;

public class EnrichPolicyReindexPipeline {
    static final String CURRENT_PIPELINE_VERSION_NAME = "7";
    static final int ENRICH_PIPELINE_LAST_UPDATED_VERSION = Version.V_7_4_0.id;

    static String pipelineName() {
        return "enrich-policy-reindex-7";
    }

    static boolean exists(ClusterState clusterState) {
        PipelineConfiguration pipeline;
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetaData().custom("ingest");
        if (ingestMetadata != null && (pipeline = (PipelineConfiguration)ingestMetadata.getPipelines().get(EnrichPolicyReindexPipeline.pipelineName())) != null) {
            Object version = pipeline.getConfigAsMap().get("version");
            return version instanceof Number && ((Number)version).intValue() >= ENRICH_PIPELINE_LAST_UPDATED_VERSION;
        }
        return false;
    }

    public static void create(Client client, ActionListener<AcknowledgedResponse> listener) {
        BytesReference pipeline = BytesReference.bytes((XContentBuilder)EnrichPolicyReindexPipeline.currentEnrichPipelineDefinition(XContentType.JSON));
        PutPipelineRequest request = new PutPipelineRequest(EnrichPolicyReindexPipeline.pipelineName(), pipeline, XContentType.JSON);
        client.admin().cluster().putPipeline(request, listener);
    }

    private static XContentBuilder currentEnrichPipelineDefinition(XContentType xContentType) {
        try {
            XContentBuilder builder = XContentBuilder.builder((XContent)xContentType.xContent());
            builder.startObject();
            builder.field("description", "This pipeline sanitizes documents that will be stored in enrich indices for ingest lookup purposes. It is an internal pipeline and should not be modified.");
            builder.field("version", ENRICH_PIPELINE_LAST_UPDATED_VERSION);
            builder.startArray("processors");
            builder.startObject();
            builder.startObject("remove");
            builder.field("field", "_id");
            builder.endObject();
            builder.endObject();
            builder.endArray();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create pipeline for enrich document sanitization", e);
        }
    }
}

