/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.enrich.action.EnrichCoordinatorProxyAction;

public abstract class AbstractEnrichProcessor
extends AbstractProcessor {
    private final String policyName;
    private final BiConsumer<SearchRequest, BiConsumer<SearchResponse, Exception>> searchRunner;
    private final String field;
    private final String targetField;
    private final boolean ignoreMissing;
    private final boolean overrideEnabled;
    protected final String matchField;
    protected final int maxMatches;

    protected AbstractEnrichProcessor(String tag, Client client, String policyName, String field, String targetField, boolean ignoreMissing, boolean overrideEnabled, String matchField, int maxMatches) {
        this(tag, AbstractEnrichProcessor.createSearchRunner(client), policyName, field, targetField, ignoreMissing, overrideEnabled, matchField, maxMatches);
    }

    protected AbstractEnrichProcessor(String tag, BiConsumer<SearchRequest, BiConsumer<SearchResponse, Exception>> searchRunner, String policyName, String field, String targetField, boolean ignoreMissing, boolean overrideEnabled, String matchField, int maxMatches) {
        super(tag);
        this.policyName = policyName;
        this.searchRunner = searchRunner;
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
        this.overrideEnabled = overrideEnabled;
        this.matchField = matchField;
        this.maxMatches = maxMatches;
    }

    public abstract QueryBuilder getQueryBuilder(Object var1);

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        try {
            Object value = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
            if (value == null) {
                handler.accept(ingestDocument, null);
                return;
            }
            QueryBuilder queryBuilder = this.getQueryBuilder(value);
            ConstantScoreQueryBuilder constantScore = new ConstantScoreQueryBuilder(queryBuilder);
            SearchSourceBuilder searchBuilder = new SearchSourceBuilder();
            searchBuilder.from(0);
            searchBuilder.size(this.maxMatches);
            searchBuilder.trackScores(false);
            searchBuilder.fetchSource(true);
            searchBuilder.query((QueryBuilder)constantScore);
            SearchRequest req = new SearchRequest();
            req.indices(new String[]{EnrichPolicy.getBaseName((String)this.getPolicyName())});
            req.preference(Preference.LOCAL.type());
            req.source(searchBuilder);
            this.searchRunner.accept(req, (searchResponse, e) -> {
                if (e != null) {
                    handler.accept((IngestDocument)null, (Exception)e);
                    return;
                }
                SearchHit[] searchHits = searchResponse.getHits().getHits();
                if (searchHits.length < 1) {
                    handler.accept(ingestDocument, null);
                    return;
                }
                if (this.overrideEnabled || !ingestDocument.hasField(this.targetField)) {
                    if (this.maxMatches == 1) {
                        Map firstDocument = searchHits[0].getSourceAsMap();
                        ingestDocument.setFieldValue(this.targetField, (Object)firstDocument);
                    } else {
                        ArrayList<Map> enrichDocuments = new ArrayList<Map>(searchHits.length);
                        for (SearchHit searchHit : searchHits) {
                            Map enrichDocument = searchHit.getSourceAsMap();
                            enrichDocuments.add(enrichDocument);
                        }
                        ingestDocument.setFieldValue(this.targetField, enrichDocuments);
                    }
                }
                handler.accept(ingestDocument, null);
            });
        }
        catch (Exception e2) {
            handler.accept(null, e2);
        }
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getType() {
        return "enrich";
    }

    String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    boolean isOverrideEnabled() {
        return this.overrideEnabled;
    }

    public String getMatchField() {
        return this.matchField;
    }

    int getMaxMatches() {
        return this.maxMatches;
    }

    private static BiConsumer<SearchRequest, BiConsumer<SearchResponse, Exception>> createSearchRunner(Client client) {
        return (req, handler) -> client.execute((ActionType)EnrichCoordinatorProxyAction.INSTANCE, (ActionRequest)req, ActionListener.wrap(resp -> handler.accept(resp, null), e -> handler.accept(null, e)));
    }
}

