/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckResponse;
import org.elasticsearch.xpack.deprecation.DeprecationChecks;

public class TransportNodeDeprecationCheckAction
extends TransportNodesAction<NodesDeprecationCheckRequest, NodesDeprecationCheckResponse, NodesDeprecationCheckAction.NodeRequest, NodesDeprecationCheckAction.NodeResponse> {
    private final Settings settings;
    private final PluginsService pluginsService;

    @Inject
    public TransportNodeDeprecationCheckAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, PluginsService pluginsService, ActionFilters actionFilters) {
        super("cluster:admin/xpack/deprecation/nodes/info", threadPool, clusterService, transportService, actionFilters, NodesDeprecationCheckRequest::new, NodesDeprecationCheckAction.NodeRequest::new, "generic", NodesDeprecationCheckAction.NodeResponse.class);
        this.settings = settings;
        this.pluginsService = pluginsService;
    }

    protected NodesDeprecationCheckResponse newResponse(NodesDeprecationCheckRequest request, List<NodesDeprecationCheckAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new NodesDeprecationCheckResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodesDeprecationCheckAction.NodeRequest newNodeRequest(NodesDeprecationCheckRequest request) {
        return new NodesDeprecationCheckAction.NodeRequest(request);
    }

    protected NodesDeprecationCheckAction.NodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodesDeprecationCheckAction.NodeResponse(in);
    }

    protected NodesDeprecationCheckAction.NodeResponse nodeOperation(NodesDeprecationCheckAction.NodeRequest request) {
        List issues = DeprecationInfoAction.filterChecks(DeprecationChecks.NODE_SETTINGS_CHECKS, c -> (DeprecationIssue)c.apply(this.settings, this.pluginsService.info()));
        return new NodesDeprecationCheckAction.NodeResponse(this.transportService.getLocalNode(), issues);
    }
}

