/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckResponse;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.deprecation.DeprecationChecks;

public class TransportDeprecationInfoAction
extends TransportMasterNodeReadAction<DeprecationInfoAction.Request, DeprecationInfoAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportDeprecationInfoAction.class);
    private final XPackLicenseState licenseState;
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportDeprecationInfoAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState, NodeClient client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/deprecation/info", transportService, clusterService, threadPool, actionFilters, DeprecationInfoAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
    }

    protected String executor() {
        return "generic";
    }

    protected DeprecationInfoAction.Response read(StreamInput in) throws IOException {
        return new DeprecationInfoAction.Response(in);
    }

    protected ClusterBlockException checkBlock(DeprecationInfoAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected final void masterOperation(DeprecationInfoAction.Request request, ClusterState state, ActionListener<DeprecationInfoAction.Response> listener) {
        if (this.licenseState.isDeprecationAllowed()) {
            NodesDeprecationCheckRequest nodeDepReq = new NodesDeprecationCheckRequest(new String[]{"_all"});
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"deprecation", (ActionType)NodesDeprecationCheckAction.INSTANCE, (ActionRequest)nodeDepReq, (ActionListener)ActionListener.wrap(response -> {
                if (response.hasFailures()) {
                    List failedNodeIds = response.failures().stream().map(failure -> failure.nodeId() + ": " + failure.getMessage()).collect(Collectors.toList());
                    logger.warn("nodes failed to run deprecation checks: {}", failedNodeIds);
                    for (FailedNodeException failure2 : response.failures()) {
                        logger.debug("node {} failed to run deprecation checks: {}", (Object)failure2.nodeId(), (Object)failure2);
                    }
                }
                this.getDatafeedConfigs((ActionListener<List<DatafeedConfig>>)ActionListener.wrap(datafeeds -> listener.onResponse((Object)DeprecationInfoAction.Response.from((ClusterState)state, (NamedXContentRegistry)this.xContentRegistry, (IndexNameExpressionResolver)this.indexNameExpressionResolver, (String[])request.indices(), (IndicesOptions)request.indicesOptions(), (List)datafeeds, (NodesDeprecationCheckResponse)response, DeprecationChecks.INDEX_SETTINGS_CHECKS, DeprecationChecks.CLUSTER_SETTINGS_CHECKS, DeprecationChecks.ML_SETTINGS_CHECKS)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"deprecation"));
        }
    }

    private void getDatafeedConfigs(ActionListener<List<DatafeedConfig>> listener) {
        if (!((Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(this.settings)).booleanValue()) {
            listener.onResponse(Collections.emptyList());
        } else {
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"deprecation", (ActionType)GetDatafeedsAction.INSTANCE, (ActionRequest)new GetDatafeedsAction.Request("_all"), (ActionListener)ActionListener.wrap(datafeedsResponse -> listener.onResponse((Object)datafeedsResponse.getResponse().results()), arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

