/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.deprecation.DeprecationInfoAction;

public class RestDeprecationInfoAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestDeprecationInfoAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);

    public RestDeprecationInfoAction(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_migration/deprecations", (RestHandler)this, RestRequest.Method.GET, "/_xpack/migration/deprecations", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/{index}/_migration/deprecations", (RestHandler)this, RestRequest.Method.GET, "/{index}/_xpack/migration/deprecations", deprecationLogger);
    }

    public String getName() {
        return "deprecation_info";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method().equals((Object)RestRequest.Method.GET)) {
            return this.handleGet(request, client);
        }
        throw new IllegalArgumentException("illegal method [" + request.method() + "] for request [" + request.path() + "]");
    }

    private BaseRestHandler.RestChannelConsumer handleGet(RestRequest request, NodeClient client) {
        DeprecationInfoAction.Request infoRequest = new DeprecationInfoAction.Request(Strings.splitStringByCommaToArray((String)request.param("index")));
        return channel -> client.execute((ActionType)DeprecationInfoAction.INSTANCE, (ActionRequest)infoRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

