/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.Locale;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

class NodeDeprecationChecks {
    NodeDeprecationChecks() {
    }

    static DeprecationIssue checkPidfile(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, Environment.PIDFILE_SETTING, Environment.NODE_PIDFILE_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.4/breaking-changes-7.4.html#deprecate-pidfile");
    }

    static DeprecationIssue checkProcessors(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, EsExecutors.PROCESSORS_SETTING, EsExecutors.NODE_PROCESSORS_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.4/breaking-changes-7.4.html#deprecate-processors");
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting<?> replacementSetting, String url) {
        assert (deprecatedSetting.isDeprecated()) : deprecatedSetting;
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String replacementSettingKey = replacementSetting.getKey();
        String value = deprecatedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "setting [%s] is deprecated in favor of setting [%s]", deprecatedSettingKey, replacementSettingKey);
        String details = String.format(Locale.ROOT, "the setting [%s] is currently set to [%s], instead set [%s] to [%s]", deprecatedSettingKey, value, replacementSettingKey, value);
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details);
    }
}

