/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public abstract class SingleGroupSource
implements Writeable,
ToXContentObject {
    protected static final ParseField FIELD = new ParseField("field", new String[0]);
    protected final String field;

    static <T> void declareValuesSourceFields(AbstractObjectParser<? extends SingleGroupSource, T> parser) {
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
    }

    public SingleGroupSource(String field) {
        this.field = field;
    }

    public SingleGroupSource(StreamInput in) throws IOException {
        this.field = in.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.field);
    }

    public abstract Type getType();

    public abstract boolean supportsIncrementalBucketUpdate();

    public abstract QueryBuilder getIncrementalBucketUpdateFilterQuery(Set<String> var1);

    public String getField() {
        return this.field;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SingleGroupSource that = (SingleGroupSource)other;
        return Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.field);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static enum Type {
        TERMS(0),
        HISTOGRAM(1),
        DATE_HISTOGRAM(2);

        private final byte id;

        private Type(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public static Type fromId(byte id) {
            switch (id) {
                case 0: {
                    return TERMS;
                }
                case 1: {
                    return HISTOGRAM;
                }
                case 2: {
                    return DATE_HISTOGRAM;
                }
            }
            throw new IllegalArgumentException("unknown type");
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

