/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexing.IndexerJobStats;

public class TransformIndexerStats
extends IndexerJobStats {
    private static final String DEFAULT_TRANSFORM_ID = "_all";
    public static final String NAME = "data_frame_indexer_transform_stats";
    public static ParseField NUM_PAGES = new ParseField("pages_processed", new String[0]);
    public static ParseField NUM_INPUT_DOCUMENTS = new ParseField("documents_processed", new String[0]);
    public static ParseField NUM_OUTPUT_DOCUMENTS = new ParseField("documents_indexed", new String[0]);
    public static ParseField NUM_INVOCATIONS = new ParseField("trigger_count", new String[0]);
    public static ParseField INDEX_TIME_IN_MS = new ParseField("index_time_in_ms", new String[0]);
    public static ParseField SEARCH_TIME_IN_MS = new ParseField("search_time_in_ms", new String[0]);
    public static ParseField INDEX_TOTAL = new ParseField("index_total", new String[0]);
    public static ParseField SEARCH_TOTAL = new ParseField("search_total", new String[0]);
    public static ParseField SEARCH_FAILURES = new ParseField("search_failures", new String[0]);
    public static ParseField INDEX_FAILURES = new ParseField("index_failures", new String[0]);
    public static ParseField EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS = new ParseField("exponential_avg_checkpoint_duration_ms", new String[0]);
    public static ParseField EXPONENTIAL_AVG_DOCUMENTS_INDEXED = new ParseField("exponential_avg_documents_indexed", new String[0]);
    public static ParseField EXPONENTIAL_AVG_DOCUMENTS_PROCESSED = new ParseField("exponential_avg_documents_processed", new String[0]);
    private static final int EXP_AVG_WINDOW = 10;
    private static final double ALPHA = 0.18181818181818182;
    private static final ConstructingObjectParser<TransformIndexerStats, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_indexer_transform_stats", true, args -> new TransformIndexerStats((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3], (Long)args[4], (Long)args[5], (Long)args[6], (Long)args[7], (Long)args[8], (Long)args[9], (Double)args[10], (Double)args[11], (Double)args[12]));
    private double expAvgCheckpointDurationMs;
    private double expAvgDocumentsIndexed;
    private double expAvgDocumentsProcessed;

    public TransformIndexerStats() {
    }

    public TransformIndexerStats(long numPages, long numInputDocuments, long numOutputDocuments, long numInvocations, long indexTime, long searchTime, long indexTotal, long searchTotal, long indexFailures, long searchFailures, Double expAvgCheckpointDurationMs, Double expAvgDocumentsIndexed, Double expAvgDocumentsProcessed) {
        super(numPages, numInputDocuments, numOutputDocuments, numInvocations, indexTime, searchTime, indexTotal, searchTotal, indexFailures, searchFailures);
        this.expAvgCheckpointDurationMs = expAvgCheckpointDurationMs == null ? 0.0 : expAvgCheckpointDurationMs;
        this.expAvgDocumentsIndexed = expAvgDocumentsIndexed == null ? 0.0 : expAvgDocumentsIndexed;
        this.expAvgDocumentsProcessed = expAvgDocumentsProcessed == null ? 0.0 : expAvgDocumentsProcessed;
    }

    public TransformIndexerStats(long numPages, long numInputDocuments, long numOutputDocuments, long numInvocations, long indexTime, long searchTime, long indexTotal, long searchTotal, long indexFailures, long searchFailures) {
        this(numPages, numInputDocuments, numOutputDocuments, numInvocations, indexTime, searchTime, indexTotal, searchTotal, indexFailures, searchFailures, 0.0, 0.0, 0.0);
    }

    public TransformIndexerStats(TransformIndexerStats other) {
        this(other.numPages, other.numInputDocuments, other.numOuputDocuments, other.numInvocations, other.indexTime, other.searchTime, other.indexTotal, other.searchTotal, other.indexFailures, other.searchFailures);
        this.expAvgCheckpointDurationMs = other.expAvgCheckpointDurationMs;
        this.expAvgDocumentsIndexed = other.expAvgDocumentsIndexed;
        this.expAvgDocumentsProcessed = other.expAvgDocumentsProcessed;
    }

    public TransformIndexerStats(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(Version.V_7_4_0)) {
            in.readString();
        }
        if (in.getVersion().onOrAfter(Version.V_7_4_0)) {
            this.expAvgCheckpointDurationMs = in.readDouble();
            this.expAvgDocumentsIndexed = in.readDouble();
            this.expAvgDocumentsProcessed = in.readDouble();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_7_4_0)) {
            out.writeString(DEFAULT_TRANSFORM_ID);
        }
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeDouble(this.expAvgCheckpointDurationMs);
            out.writeDouble(this.expAvgDocumentsIndexed);
            out.writeDouble(this.expAvgDocumentsProcessed);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_PAGES.getPreferredName(), this.numPages);
        builder.field(NUM_INPUT_DOCUMENTS.getPreferredName(), this.numInputDocuments);
        builder.field(NUM_OUTPUT_DOCUMENTS.getPreferredName(), this.numOuputDocuments);
        builder.field(NUM_INVOCATIONS.getPreferredName(), this.numInvocations);
        builder.field(INDEX_TIME_IN_MS.getPreferredName(), this.indexTime);
        builder.field(INDEX_TOTAL.getPreferredName(), this.indexTotal);
        builder.field(INDEX_FAILURES.getPreferredName(), this.indexFailures);
        builder.field(SEARCH_TIME_IN_MS.getPreferredName(), this.searchTime);
        builder.field(SEARCH_TOTAL.getPreferredName(), this.searchTotal);
        builder.field(SEARCH_FAILURES.getPreferredName(), this.searchFailures);
        builder.field(EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS.getPreferredName(), this.expAvgCheckpointDurationMs);
        builder.field(EXPONENTIAL_AVG_DOCUMENTS_INDEXED.getPreferredName(), this.expAvgDocumentsIndexed);
        builder.field(EXPONENTIAL_AVG_DOCUMENTS_PROCESSED.getPreferredName(), this.expAvgDocumentsProcessed);
        builder.endObject();
        return builder;
    }

    public double getExpAvgCheckpointDurationMs() {
        return this.expAvgCheckpointDurationMs;
    }

    public double getExpAvgDocumentsIndexed() {
        return this.expAvgDocumentsIndexed;
    }

    public double getExpAvgDocumentsProcessed() {
        return this.expAvgDocumentsProcessed;
    }

    public void incrementCheckpointExponentialAverages(long checkpointDurationMs, long docsIndexed, long docsProcessed) {
        assert (checkpointDurationMs >= 0L);
        assert (docsIndexed >= 0L);
        assert (docsProcessed >= 0L);
        if (this.expAvgCheckpointDurationMs == 0.0 && this.expAvgDocumentsIndexed == 0.0 && this.expAvgDocumentsProcessed == 0.0) {
            this.expAvgCheckpointDurationMs = checkpointDurationMs;
            this.expAvgDocumentsIndexed = docsIndexed;
            this.expAvgDocumentsProcessed = docsProcessed;
        } else {
            this.expAvgCheckpointDurationMs = this.calculateExpAvg(this.expAvgCheckpointDurationMs, 0.18181818181818182, checkpointDurationMs);
            this.expAvgDocumentsIndexed = this.calculateExpAvg(this.expAvgDocumentsIndexed, 0.18181818181818182, docsIndexed);
            this.expAvgDocumentsProcessed = this.calculateExpAvg(this.expAvgDocumentsProcessed, 0.18181818181818182, docsProcessed);
        }
    }

    private double calculateExpAvg(double previousExpValue, double alpha, long observedValue) {
        return alpha * (double)observedValue + (1.0 - alpha) * previousExpValue;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformIndexerStats that = (TransformIndexerStats)other;
        return Objects.equals(this.numPages, that.numPages) && Objects.equals(this.numInputDocuments, that.numInputDocuments) && Objects.equals(this.numOuputDocuments, that.numOuputDocuments) && Objects.equals(this.numInvocations, that.numInvocations) && Objects.equals(this.indexTime, that.indexTime) && Objects.equals(this.searchTime, that.searchTime) && Objects.equals(this.indexFailures, that.indexFailures) && Objects.equals(this.searchFailures, that.searchFailures) && Objects.equals(this.indexTotal, that.indexTotal) && Objects.equals(this.searchTotal, that.searchTotal) && Objects.equals(this.expAvgCheckpointDurationMs, that.expAvgCheckpointDurationMs) && Objects.equals(this.expAvgDocumentsIndexed, that.expAvgDocumentsIndexed) && Objects.equals(this.expAvgDocumentsProcessed, that.expAvgDocumentsProcessed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.numPages, this.numInputDocuments, this.numOuputDocuments, this.numInvocations, this.indexTime, this.searchTime, this.indexFailures, this.searchFailures, this.indexTotal, this.searchTotal, this.expAvgCheckpointDurationMs, this.expAvgDocumentsIndexed, this.expAvgDocumentsProcessed);
    }

    public static TransformIndexerStats fromXContent(XContentParser parser) {
        try {
            return (TransformIndexerStats)LENIENT_PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_PAGES);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INPUT_DOCUMENTS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_OUTPUT_DOCUMENTS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INVOCATIONS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TIME_IN_MS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TIME_IN_MS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TOTAL);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TOTAL);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_FAILURES);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_FAILURES);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_DOCUMENTS_INDEXED);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_DOCUMENTS_PROCESSED);
    }
}

