/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.TransformField;

public class TransformCheckpoint
implements Writeable,
ToXContentObject {
    public static TransformCheckpoint EMPTY = new TransformCheckpoint("empty", 0L, -1L, Collections.emptyMap(), 0L);
    public static final ParseField CHECKPOINT = new ParseField("checkpoint", new String[0]);
    public static final ParseField INDICES = new ParseField("indices", new String[0]);
    private static final String NAME = "data_frame_transform_checkpoint";
    private static final ConstructingObjectParser<TransformCheckpoint, Void> STRICT_PARSER = TransformCheckpoint.createParser(false);
    private static final ConstructingObjectParser<TransformCheckpoint, Void> LENIENT_PARSER = TransformCheckpoint.createParser(true);
    private final String transformId;
    private final long timestampMillis;
    private final long checkpoint;
    private final Map<String, long[]> indicesCheckpoints;
    private final long timeUpperBoundMillis;

    private static ConstructingObjectParser<TransformCheckpoint, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, args -> {
            String id = (String)args[0];
            long timestamp = (Long)args[1];
            long checkpoint = (Long)args[2];
            Map checkpoints = (Map)args[3];
            Long timeUpperBound = (Long)args[4];
            return new TransformCheckpoint(id, timestamp, checkpoint, checkpoints, timeUpperBound);
        });
        parser.declareString(ConstructingObjectParser.constructorArg(), TransformField.ID);
        parser.declareLong(ConstructingObjectParser.constructorArg(), TransformField.TIMESTAMP_MILLIS);
        parser.declareLong(ConstructingObjectParser.constructorArg(), CHECKPOINT);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            TreeMap<String, long[]> checkPointsByIndexName = new TreeMap<String, long[]>();
            XContentParser.Token token = null;
            while ((token = p.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ParsingException(p.getTokenLocation(), "Unexpected token " + token + " ", new Object[0]);
                }
                String indexName = p.currentName();
                token = p.nextToken();
                if (token != XContentParser.Token.START_ARRAY) {
                    throw new ParsingException(p.getTokenLocation(), "Unexpected token " + token + " ", new Object[0]);
                }
                long[] checkpoints = p.listOrderedMap().stream().mapToLong(num -> ((Number)num).longValue()).toArray();
                checkPointsByIndexName.put(indexName, checkpoints);
            }
            return checkPointsByIndexName;
        }, INDICES);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), TransformField.TIME_UPPER_BOUND_MILLIS);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.INDEX_DOC_TYPE);
        return parser;
    }

    public TransformCheckpoint(String transformId, long timestamp, long checkpoint, Map<String, long[]> checkpoints, Long timeUpperBound) {
        this.transformId = Objects.requireNonNull(transformId);
        this.timestampMillis = timestamp;
        this.checkpoint = checkpoint;
        this.indicesCheckpoints = Collections.unmodifiableMap(checkpoints);
        this.timeUpperBoundMillis = timeUpperBound == null ? 0L : timeUpperBound;
    }

    public TransformCheckpoint(StreamInput in) throws IOException {
        this.transformId = in.readString();
        this.timestampMillis = in.readLong();
        this.checkpoint = in.readLong();
        this.indicesCheckpoints = TransformCheckpoint.readCheckpoints(in.readMap());
        this.timeUpperBoundMillis = in.readLong();
    }

    public boolean isEmpty() {
        return this.indicesCheckpoints.isEmpty();
    }

    public boolean isTransient() {
        return this.checkpoint == -1L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.ID.getPreferredName(), this.transformId);
        builder.field(CHECKPOINT.getPreferredName(), this.checkpoint);
        builder.field(TransformField.INDEX_DOC_TYPE.getPreferredName(), NAME);
        builder.startObject(INDICES.getPreferredName());
        for (Map.Entry<String, long[]> entry : this.indicesCheckpoints.entrySet()) {
            builder.array(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        builder.field(TransformField.TIMESTAMP_MILLIS.getPreferredName(), this.timestampMillis);
        if (this.timeUpperBoundMillis > 0L) {
            builder.field(TransformField.TIME_UPPER_BOUND_MILLIS.getPreferredName(), this.timeUpperBoundMillis);
        }
        builder.endObject();
        return builder;
    }

    public String getTransformId() {
        return this.transformId;
    }

    public long getTimestamp() {
        return this.timestampMillis;
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    public Map<String, long[]> getIndicesCheckpoints() {
        return this.indicesCheckpoints;
    }

    public long getTimeUpperBound() {
        return this.timeUpperBoundMillis;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.transformId);
        out.writeLong(this.timestampMillis);
        out.writeLong(this.checkpoint);
        out.writeGenericValue(this.indicesCheckpoints);
        out.writeLong(this.timeUpperBoundMillis);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformCheckpoint that = (TransformCheckpoint)other;
        return this.timestampMillis == that.timestampMillis && this.checkpoint == that.checkpoint && this.timeUpperBoundMillis == that.timeUpperBoundMillis && this.matches(that);
    }

    public boolean matches(TransformCheckpoint that) {
        if (this == that) {
            return true;
        }
        return Objects.equals(this.transformId, that.transformId) && this.indicesCheckpoints.size() == that.indicesCheckpoints.size() && this.indicesCheckpoints.entrySet().stream().allMatch(e -> Arrays.equals((long[])e.getValue(), that.indicesCheckpoints.get(e.getKey())));
    }

    public int hashCode() {
        int hash = Objects.hash(this.transformId, this.timestampMillis, this.checkpoint, this.timeUpperBoundMillis);
        for (Map.Entry<String, long[]> e : this.indicesCheckpoints.entrySet()) {
            hash = 31 * hash + Objects.hash(e.getKey(), Arrays.hashCode(e.getValue()));
        }
        return hash;
    }

    public static TransformCheckpoint fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (TransformCheckpoint)LENIENT_PARSER.apply(parser, null) : (TransformCheckpoint)STRICT_PARSER.apply(parser, null);
    }

    public static String documentId(String transformId, long checkpoint) {
        if (checkpoint < 0L) {
            throw new IllegalArgumentException("checkpoint must be a positive number");
        }
        return "data_frame_transform_checkpoint-" + transformId + "-" + checkpoint;
    }

    public static long getBehind(TransformCheckpoint oldCheckpoint, TransformCheckpoint newCheckpoint) {
        if (oldCheckpoint.isTransient()) {
            if (!newCheckpoint.isTransient()) {
                throw new IllegalArgumentException("can not compare transient against a non transient checkpoint");
            }
        } else if (!newCheckpoint.isTransient() && oldCheckpoint.getCheckpoint() > newCheckpoint.getCheckpoint()) {
            throw new IllegalArgumentException("old checkpoint is newer than new checkpoint");
        }
        long oldCheckPointOperationsSum = 0L;
        long newCheckPointOperationsSum = 0L;
        for (Map.Entry<String, long[]> entry : oldCheckpoint.indicesCheckpoints.entrySet()) {
            if (!newCheckpoint.indicesCheckpoints.containsKey(entry.getKey())) continue;
            oldCheckPointOperationsSum += Arrays.stream(entry.getValue()).sum() + (long)entry.getValue().length;
        }
        for (long[] v : newCheckpoint.indicesCheckpoints.values()) {
            newCheckPointOperationsSum += Arrays.stream(v).sum() + (long)v.length;
        }
        if (newCheckPointOperationsSum < oldCheckPointOperationsSum) {
            return -1L;
        }
        return newCheckPointOperationsSum - oldCheckPointOperationsSum;
    }

    private static Map<String, long[]> readCheckpoints(Map<String, Object> readMap) {
        TreeMap<String, long[]> checkpoints = new TreeMap<String, long[]>();
        for (Map.Entry<String, Object> e : readMap.entrySet()) {
            if (e.getValue() instanceof long[]) {
                checkpoints.put(e.getKey(), (long[])e.getValue());
                continue;
            }
            throw new ElasticsearchParseException("expecting the checkpoints for [{}] to be a long[], but found [{}] instead", new Object[]{e.getKey(), e.getValue().getClass()});
        }
        return checkpoints;
    }
}

