/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;

public class UpdateTransformAction
extends ActionType<Response> {
    public static final UpdateTransformAction INSTANCE = new UpdateTransformAction();
    public static final String NAME = "cluster:admin/transform/update";
    private static final TimeValue MIN_FREQUENCY = TimeValue.timeValueSeconds((long)1L);
    private static final TimeValue MAX_FREQUENCY = TimeValue.timeValueHours((long)1L);

    private UpdateTransformAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final TransformConfig config;

        public Response(TransformConfig config) {
            this.config = config;
        }

        public Response(StreamInput in) throws IOException {
            this.config = new TransformConfig(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.config.writeTo(out);
        }

        public int hashCode() {
            return this.config.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals((Object)this.config, (Object)other.config);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.config.toXContent(builder, params);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TransformConfigUpdate update;
        private final String id;
        private final boolean deferValidation;

        public Request(TransformConfigUpdate update, String id, boolean deferValidation) {
            this.update = update;
            this.id = id;
            this.deferValidation = deferValidation;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.update = new TransformConfigUpdate(in);
            this.id = in.readString();
            this.deferValidation = in.readBoolean();
        }

        public static Request fromXContent(XContentParser parser, String id, boolean deferValidation) {
            return new Request(TransformConfigUpdate.fromXContent(parser), id, deferValidation);
        }

        public ActionRequestValidationException validate() {
            TimeValue frequency;
            ActionRequestValidationException validationException = null;
            if (this.update.getDestination() != null && this.update.getDestination().getIndex() != null) {
                String destIndex = this.update.getDestination().getIndex();
                try {
                    MetaDataCreateIndexService.validateIndexOrAliasName((String)destIndex, InvalidIndexNameException::new);
                    if (!destIndex.toLowerCase(Locale.ROOT).equals(destIndex)) {
                        validationException = ValidateActions.addValidationError((String)("dest.index [" + destIndex + "] must be lowercase"), (ActionRequestValidationException)validationException);
                    }
                }
                catch (InvalidIndexNameException ex) {
                    validationException = ValidateActions.addValidationError((String)ex.getMessage(), validationException);
                }
            }
            if ((frequency = this.update.getFrequency()) != null) {
                if (frequency.compareTo(MIN_FREQUENCY) < 0) {
                    validationException = ValidateActions.addValidationError((String)("minimum permitted [" + TransformField.FREQUENCY + "] is [" + MIN_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                } else if (frequency.compareTo(MAX_FREQUENCY) > 0) {
                    validationException = ValidateActions.addValidationError((String)("highest permitted [" + TransformField.FREQUENCY + "] is [" + MAX_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public String getId() {
            return this.id;
        }

        public boolean isDeferValidation() {
            return this.deferValidation;
        }

        public TransformConfigUpdate getUpdate() {
            return this.update;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.update.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.deferValidation);
        }

        public int hashCode() {
            return Objects.hash(this.update, this.id, this.deferValidation);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.update, other.update) && this.deferValidation == other.deferValidation && this.id.equals(other.id);
        }
    }
}

