/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class StopTransformAction
extends ActionType<Response> {
    public static final StopTransformAction INSTANCE = new StopTransformAction();
    public static final String NAME = "cluster:admin/transform/stop";
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);

    private StopTransformAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean acknowledged;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.acknowledged = in.readBoolean();
        }

        public Response(boolean acknowledged) {
            super(Collections.emptyList(), Collections.emptyList());
            this.acknowledged = acknowledged;
        }

        public Response(List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures, boolean acknowledged) {
            super(taskFailures, nodeFailures);
            this.acknowledged = acknowledged;
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.acknowledged);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentCommon(builder, params);
            builder.field("acknowledged", this.acknowledged);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.acknowledged == response.acknowledged;
        }

        public int hashCode() {
            return Objects.hash(this.acknowledged);
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        private final String id;
        private final boolean waitForCompletion;
        private final boolean force;
        private final boolean allowNoMatch;
        private Set<String> expandedIds;

        public Request(String id, boolean waitForCompletion, boolean force, @Nullable TimeValue timeout, boolean allowNoMatch) {
            this.id = ExceptionsHelper.requireNonNull(id, TransformField.ID.getPreferredName());
            this.waitForCompletion = waitForCompletion;
            this.force = force;
            this.setTimeout(timeout == null ? DEFAULT_TIMEOUT : timeout);
            this.allowNoMatch = allowNoMatch;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.waitForCompletion = in.readBoolean();
            this.force = in.readBoolean();
            if (in.readBoolean()) {
                this.expandedIds = new HashSet<String>(Arrays.asList(in.readStringArray()));
            }
            this.allowNoMatch = in.getVersion().onOrAfter(Version.V_7_3_0) ? in.readBoolean() : true;
        }

        public String getId() {
            return this.id;
        }

        public boolean waitForCompletion() {
            return this.waitForCompletion;
        }

        public boolean isForce() {
            return this.force;
        }

        public Set<String> getExpandedIds() {
            return this.expandedIds;
        }

        public void setExpandedIds(Set<String> expandedIds) {
            this.expandedIds = expandedIds;
        }

        public boolean isAllowNoMatch() {
            return this.allowNoMatch;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.waitForCompletion);
            out.writeBoolean(this.force);
            boolean hasExpandedIds = this.expandedIds != null;
            out.writeBoolean(hasExpandedIds);
            if (hasExpandedIds) {
                out.writeStringArray(this.expandedIds.toArray(new String[0]));
            }
            if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                out.writeBoolean(this.allowNoMatch);
            }
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.waitForCompletion, this.force, this.expandedIds, this.getTimeout(), this.allowNoMatch);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            if (!Objects.equals(this.getTimeout(), other.getTimeout())) {
                return false;
            }
            return Objects.equals(this.id, other.id) && Objects.equals(this.waitForCompletion, other.waitForCompletion) && Objects.equals(this.force, other.force) && Objects.equals(this.expandedIds, other.expandedIds) && this.allowNoMatch == other.allowNoMatch;
        }

        public boolean match(Task task) {
            if (task.getDescription().startsWith("data_frame_")) {
                String id = task.getDescription().substring("data_frame_".length());
                if (this.expandedIds != null) {
                    return this.expandedIds.contains(id);
                }
            }
            return false;
        }
    }
}

