/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public class PreviewTransformAction
extends ActionType<Response> {
    public static final PreviewTransformAction INSTANCE = new PreviewTransformAction();
    public static final String NAME = "cluster:admin/transform/preview";

    private PreviewTransformAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private List<Map<String, Object>> docs;
        private Map<String, Object> mappings;
        public static ParseField PREVIEW = new ParseField("preview", new String[0]);
        public static ParseField MAPPINGS = new ParseField("mappings", new String[0]);
        static ObjectParser<Response, Void> PARSER = new ObjectParser("data_frame_transform_preview", Response::new);

        public Response() {
        }

        public Response(StreamInput in) throws IOException {
            int size = in.readInt();
            this.docs = new ArrayList<Map<String, Object>>(size);
            for (int i = 0; i < size; ++i) {
                this.docs.add(in.readMap());
            }
            if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
                Map objectMap = in.readMap();
                this.mappings = objectMap == null ? null : Collections.unmodifiableMap(objectMap);
            }
        }

        public Response(List<Map<String, Object>> docs) {
            this.docs = new ArrayList<Map<String, Object>>(docs);
        }

        public void setDocs(List<Map<String, Object>> docs) {
            this.docs = new ArrayList<Map<String, Object>>(docs);
        }

        public void setMappings(Map<String, Object> mappings) {
            this.mappings = Collections.unmodifiableMap(mappings);
        }

        public void setMappingsFromStringMap(Map<String, String> mappings) {
            HashMap fieldMappings = new HashMap();
            mappings.forEach((k, v) -> fieldMappings.put(k, Collections.singletonMap("type", v)));
            this.mappings = Collections.singletonMap("properties", fieldMappings);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.docs.size());
            for (Map<String, Object> doc : this.docs) {
                out.writeMapWithConsistentOrder(doc);
            }
            if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                out.writeMap(this.mappings);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(PREVIEW.getPreferredName(), this.docs);
            if (this.mappings != null) {
                builder.field(MAPPINGS.getPreferredName(), this.mappings);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(other.docs, this.docs) && Objects.equals(other.mappings, this.mappings);
        }

        public int hashCode() {
            return Objects.hash(this.docs, this.mappings);
        }

        public static Response fromXContent(XContentParser parser) throws IOException {
            return (Response)((Object)PARSER.parse(parser, null));
        }

        static {
            PARSER.declareObjectArray(Response::setDocs, (p, c) -> p.mapOrdered(), PREVIEW);
            PARSER.declareObject(Response::setMappings, (p, c) -> p.mapOrdered(), MAPPINGS);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private final TransformConfig config;

        public Request(TransformConfig config) {
            this.config = config;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new TransformConfig(in);
        }

        public static Request fromXContent(XContentParser parser) throws IOException {
            Map destMap;
            String pipeline;
            Map content = parser.map();
            HashMap<String, String> tempDestination = new HashMap<String, String>();
            tempDestination.put(DestConfig.INDEX.getPreferredName(), "unused-transform-preview-index");
            Object providedDestination = content.get(TransformField.DESTINATION.getPreferredName());
            if (providedDestination instanceof Map && (pipeline = (String)(destMap = (Map)providedDestination).get(DestConfig.PIPELINE.getPreferredName())) != null) {
                tempDestination.put(DestConfig.PIPELINE.getPreferredName(), pipeline);
            }
            content.put(TransformField.DESTINATION.getPreferredName(), tempDestination);
            content.put(TransformField.ID.getPreferredName(), "transform-preview");
            try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(content);){
                Request request;
                block13: {
                    XContentParser newParser = XContentType.JSON.xContent().createParser(parser.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());
                    try {
                        request = new Request(TransformConfig.fromXContent(newParser, "transform-preview", false));
                        if (newParser == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (newParser != null) {
                            try {
                                newParser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    newParser.close();
                }
                return request;
            }
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.config.getPivotConfig() != null) {
                for (String failure : this.config.getPivotConfig().aggFieldValidation()) {
                    validationException = ValidateActions.addValidationError((String)failure, validationException);
                }
            }
            return validationException;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.config.toXContent(builder, params);
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.config});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals((Object)this.config, (Object)other.config);
        }
    }
}

