/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public abstract class IndexTemplateRegistry
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(IndexTemplateRegistry.class);
    protected final Settings settings;
    protected final Client client;
    protected final ThreadPool threadPool;
    protected final NamedXContentRegistry xContentRegistry;
    protected final ConcurrentMap<String, AtomicBoolean> templateCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();
    protected final ConcurrentMap<String, AtomicBoolean> policyCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();

    public IndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        this.settings = nodeSettings;
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        clusterService.addListener((ClusterStateListener)this);
    }

    protected abstract List<IndexTemplateConfig> getTemplateConfigs();

    protected abstract List<LifecyclePolicyConfig> getPolicyConfigs();

    protected abstract String getOrigin();

    protected void onPutTemplateFailure(IndexTemplateConfig config, Exception e) {
        logger.error((Message)new ParameterizedMessage("error adding index template [{}] from [{}] for [{}]", new Object[]{config.getTemplateName(), config.getFileName(), this.getOrigin()}), (Throwable)e);
    }

    protected void onPutPolicyFailure(LifecyclePolicy policy, Exception e) {
        logger.error((Message)new ParameterizedMessage("error adding lifecycle policy [{}] for [{}]", (Object)policy.getName(), (Object)this.getOrigin()), (Throwable)e);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode masterNode = event.state().getNodes().getMasterNode();
        if (masterNode == null) {
            return;
        }
        DiscoveryNode localNode = event.state().getNodes().getLocalNode();
        boolean localNodeVersionAfterMaster = localNode.getVersion().after(masterNode.getVersion());
        if (event.localNodeMaster() || localNodeVersionAfterMaster) {
            this.addTemplatesIfMissing(state);
            this.addIndexLifecyclePoliciesIfMissing(state);
        }
    }

    private void addTemplatesIfMissing(ClusterState state) {
        List<IndexTemplateConfig> indexTemplates = this.getTemplateConfigs();
        for (IndexTemplateConfig template : indexTemplates) {
            String templateName = template.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (!creationCheck.compareAndSet(false, true)) continue;
            if (!state.metaData().getTemplates().containsKey((Object)templateName)) {
                logger.debug("adding index template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                this.putTemplate(template, creationCheck);
                continue;
            }
            creationCheck.set(false);
            logger.trace("not adding index template [{}] for [{}], because it already exists", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private void putTemplate(final IndexTemplateConfig config, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(config.loadBytes(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding index template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(config, e);
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putTemplate(arg_0, arg_1));
        });
    }

    private void addIndexLifecyclePoliciesIfMissing(ClusterState state) {
        boolean ilmSupported = (Boolean)XPackSettings.INDEX_LIFECYCLE_ENABLED.get(this.settings);
        if (ilmSupported) {
            Optional<IndexLifecycleMetadata> maybeMeta = Optional.ofNullable((IndexLifecycleMetadata)state.metaData().custom("index_lifecycle"));
            List policies = this.getPolicyConfigs().stream().map(policyConfig -> policyConfig.load(this.xContentRegistry)).collect(Collectors.toList());
            for (LifecyclePolicy policy : policies) {
                boolean policyNeedsToBeCreated;
                AtomicBoolean creationCheck = this.policyCreationsInProgress.computeIfAbsent(policy.getName(), key -> new AtomicBoolean(false));
                if (!creationCheck.compareAndSet(false, true)) continue;
                boolean bl = policyNeedsToBeCreated = !maybeMeta.flatMap(ilmMeta -> Optional.ofNullable(ilmMeta.getPolicies().get(policy.getName()))).isPresent();
                if (policyNeedsToBeCreated) {
                    logger.debug("adding lifecycle policy [{}] for [{}], because it doesn't exist", (Object)policy.getName(), (Object)this.getOrigin());
                    this.putPolicy(policy, creationCheck);
                    continue;
                }
                logger.trace("not adding lifecycle policy [{}] for [{}], because it already exists", (Object)policy.getName(), (Object)this.getOrigin());
                creationCheck.set(false);
            }
        }
    }

    private void putPolicy(final LifecyclePolicy policy, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutLifecycleAction.Request request = new PutLifecycleAction.Request(policy);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<PutLifecycleAction.Response>(){

                public void onResponse(PutLifecycleAction.Response response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding lifecycle policy [{}] for [{}], request was not acknowledged", (Object)policy.getName(), (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutPolicyFailure(policy, e);
                }
            }, (req, listener) -> new XPackClient(this.client).ilmClient().putLifecyclePolicy((PutLifecycleAction.Request)((Object)((Object)req)), (ActionListener<PutLifecycleAction.Response>)listener));
        });
    }
}

