/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class SSLConfigurationReloader {
    private static final Logger logger = LogManager.getLogger(SSLConfigurationReloader.class);
    private final ConcurrentHashMap<Path, ChangeListener> pathToChangeListenerMap = new ConcurrentHashMap();
    private final Environment environment;
    private final ResourceWatcherService resourceWatcherService;
    private final SSLService sslService;

    public SSLConfigurationReloader(Environment env, SSLService sslService, ResourceWatcherService resourceWatcher) {
        this.environment = env;
        this.resourceWatcherService = resourceWatcher;
        this.sslService = sslService;
        this.startWatching(sslService.getLoadedSSLConfigurations());
    }

    private void startWatching(Collection<SSLConfiguration> sslConfigurations) {
        for (SSLConfiguration sslConfiguration : sslConfigurations) {
            for (Path directory : SSLConfigurationReloader.directoriesToMonitor(sslConfiguration.filesToMonitor(this.environment))) {
                this.pathToChangeListenerMap.compute(directory, (path, listener) -> {
                    if (listener != null) {
                        ((ChangeListener)listener).addSSLConfiguration(sslConfiguration);
                        return listener;
                    }
                    ChangeListener changeListener = new ChangeListener();
                    changeListener.addSSLConfiguration(sslConfiguration);
                    FileWatcher fileWatcher = new FileWatcher(path);
                    fileWatcher.addListener((Object)changeListener);
                    try {
                        this.resourceWatcherService.add((ResourceWatcher)fileWatcher, ResourceWatcherService.Frequency.HIGH);
                        return changeListener;
                    }
                    catch (IOException e) {
                        logger.error("failed to start watching directory [{}] for ssl configuration [{}]", path, (Object)sslConfiguration);
                        return null;
                    }
                });
            }
        }
    }

    void reloadSSLContext(SSLConfiguration configuration) {
        logger.debug("reloading ssl configuration [{}]", (Object)configuration);
        this.sslService.sslContextHolder(configuration).reload();
    }

    private static Set<Path> directoriesToMonitor(List<Path> filePaths) {
        HashSet<Path> paths = new HashSet<Path>();
        for (Path path : filePaths) {
            paths.add(path.getParent());
        }
        return paths;
    }

    private class ChangeListener
    implements FileChangesListener {
        private final CopyOnWriteArraySet<SSLConfiguration> sslConfigurations = new CopyOnWriteArraySet();

        private ChangeListener() {
        }

        private void addSSLConfiguration(SSLConfiguration sslConfiguration) {
            this.sslConfigurations.add(sslConfiguration);
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            boolean reloaded = false;
            for (SSLConfiguration sslConfiguration : this.sslConfigurations) {
                if (!sslConfiguration.filesToMonitor(SSLConfigurationReloader.this.environment).contains(file)) continue;
                SSLConfigurationReloader.this.reloadSSLContext(sslConfiguration);
                reloaded = true;
            }
            if (reloaded) {
                logger.info("reloaded [{}] and updated ssl contexts using this file", (Object)file);
            }
        }
    }
}

