/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm.history;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class SnapshotLifecycleTemplateRegistry
extends IndexTemplateRegistry {
    public static final String INDEX_TEMPLATE_VERSION = "1";
    public static final String SLM_TEMPLATE_VERSION_VARIABLE = "xpack.slm.template.version";
    public static final String SLM_TEMPLATE_NAME = ".slm-history";
    public static final String SLM_POLICY_NAME = "slm-history-ilm-policy";
    public static final IndexTemplateConfig TEMPLATE_SLM_HISTORY = new IndexTemplateConfig(".slm-history", "/slm-history.json", "1", "xpack.slm.template.version");
    public static final LifecyclePolicyConfig SLM_HISTORY_POLICY = new LifecyclePolicyConfig("slm-history-ilm-policy", "/slm-history-ilm-policy.json");
    private final boolean slmHistoryEnabled;

    public SnapshotLifecycleTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.slmHistoryEnabled = (Boolean)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
    }

    @Override
    protected List<IndexTemplateConfig> getTemplateConfigs() {
        if (!this.slmHistoryEnabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(TEMPLATE_SLM_HISTORY);
    }

    @Override
    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        if (!this.slmHistoryEnabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(SLM_HISTORY_POLICY);
    }

    @Override
    protected String getOrigin() {
        return "index_lifecycle";
    }

    public boolean validate(ClusterState state) {
        boolean allTemplatesPresent = this.getTemplateConfigs().stream().map(IndexTemplateConfig::getTemplateName).allMatch(name -> state.metaData().getTemplates().containsKey(name));
        Optional<Map> maybePolicies = Optional.ofNullable((IndexLifecycleMetadata)state.metaData().custom("index_lifecycle")).map(IndexLifecycleMetadata::getPolicies);
        Set policyNames = this.getPolicyConfigs().stream().map(LifecyclePolicyConfig::getPolicyName).collect(Collectors.toSet());
        boolean allPoliciesPresent = maybePolicies.map(policies -> policies.keySet().containsAll(policyNames)).orElse(false);
        return allTemplatesPresent && allPoliciesPresent;
    }
}

