/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;

public class SnapshotRetentionConfiguration
implements ToXContentObject,
Writeable {
    public static final SnapshotRetentionConfiguration EMPTY = new SnapshotRetentionConfiguration(null, null, null);
    private static final ParseField EXPIRE_AFTER = new ParseField("expire_after", new String[0]);
    private static final ParseField MINIMUM_SNAPSHOT_COUNT = new ParseField("min_count", new String[0]);
    private static final ParseField MAXIMUM_SNAPSHOT_COUNT = new ParseField("max_count", new String[0]);
    private static final Logger logger = LogManager.getLogger(SnapshotRetentionConfiguration.class);
    private static final ConstructingObjectParser<SnapshotRetentionConfiguration, Void> PARSER = new ConstructingObjectParser("snapshot_retention", true, a -> {
        TimeValue expireAfter = a[0] == null ? null : TimeValue.parseTimeValue((String)((String)a[0]), (String)EXPIRE_AFTER.getPreferredName());
        Integer minCount = (Integer)a[1];
        Integer maxCount = (Integer)a[2];
        return new SnapshotRetentionConfiguration(expireAfter, minCount, maxCount);
    });
    private final LongSupplier nowSupplier;
    private final TimeValue expireAfter;
    private final Integer minimumSnapshotCount;
    private final Integer maximumSnapshotCount;

    SnapshotRetentionConfiguration(StreamInput in) throws IOException {
        this.nowSupplier = System::currentTimeMillis;
        this.expireAfter = in.readOptionalTimeValue();
        this.minimumSnapshotCount = in.readOptionalVInt();
        this.maximumSnapshotCount = in.readOptionalVInt();
    }

    public SnapshotRetentionConfiguration(@Nullable TimeValue expireAfter, @Nullable Integer minimumSnapshotCount, @Nullable Integer maximumSnapshotCount) {
        this(System::currentTimeMillis, expireAfter, minimumSnapshotCount, maximumSnapshotCount);
    }

    public SnapshotRetentionConfiguration(LongSupplier nowSupplier, @Nullable TimeValue expireAfter, @Nullable Integer minimumSnapshotCount, @Nullable Integer maximumSnapshotCount) {
        this.nowSupplier = nowSupplier;
        this.expireAfter = expireAfter;
        this.minimumSnapshotCount = minimumSnapshotCount;
        this.maximumSnapshotCount = maximumSnapshotCount;
        if (this.minimumSnapshotCount != null && this.minimumSnapshotCount < 1) {
            throw new IllegalArgumentException("minimum snapshot count must be at least 1, but was: " + this.minimumSnapshotCount);
        }
        if (this.maximumSnapshotCount != null && this.maximumSnapshotCount < 1) {
            throw new IllegalArgumentException("maximum snapshot count must be at least 1, but was: " + this.maximumSnapshotCount);
        }
        if (maximumSnapshotCount != null && minimumSnapshotCount != null && this.minimumSnapshotCount > this.maximumSnapshotCount) {
            throw new IllegalArgumentException("minimum snapshot count " + this.minimumSnapshotCount + " cannot be larger than maximum snapshot count " + this.maximumSnapshotCount);
        }
    }

    public static SnapshotRetentionConfiguration parse(XContentParser parser, String name) {
        return (SnapshotRetentionConfiguration)PARSER.apply(parser, null);
    }

    public TimeValue getExpireAfter() {
        return this.expireAfter;
    }

    public Integer getMinimumSnapshotCount() {
        return this.minimumSnapshotCount;
    }

    public Integer getMaximumSnapshotCount() {
        return this.maximumSnapshotCount;
    }

    public Predicate<SnapshotInfo> getSnapshotDeletionPredicate(List<SnapshotInfo> allSnapshots) {
        int totalSnapshotCount = allSnapshots.size();
        List sortedSnapshots = allSnapshots.stream().sorted(Comparator.comparingLong(SnapshotInfo::startTime)).collect(Collectors.toList());
        long successfulSnapshotCount = allSnapshots.stream().filter(snap -> SnapshotState.SUCCESS.equals((Object)snap.state())).count();
        long newestSuccessfulTimestamp = allSnapshots.stream().filter(snap -> SnapshotState.SUCCESS.equals((Object)snap.state())).mapToLong(SnapshotInfo::startTime).max().orElse(Long.MIN_VALUE);
        HashSet<SnapshotState> unsuccessfulStates = new HashSet<SnapshotState>(Arrays.asList(SnapshotState.FAILED, SnapshotState.PARTIAL));
        return si -> {
            String snapName = si.snapshotId().getName();
            if (this.expireAfter == null && unsuccessfulStates.contains(si.state()) && newestSuccessfulTimestamp > si.startTime()) {
                logger.trace("[{}]: ELIGIBLE as it is {} and there is a more recent successful snapshot", (Object)snapName, (Object)si.state());
                return true;
            }
            if (this.maximumSnapshotCount != null && successfulSnapshotCount > (long)this.maximumSnapshotCount.intValue()) {
                long snapsToDelete = successfulSnapshotCount - (long)this.maximumSnapshotCount.intValue();
                boolean eligible = sortedSnapshots.stream().limit(snapsToDelete).anyMatch(s -> s.equals(si));
                if (eligible) {
                    logger.trace("[{}]: ELIGIBLE as it is one of the {} oldest snapshots with {} non-failed snapshots ({} total), over the limit of {} maximum snapshots", (Object)snapName, (Object)snapsToDelete, (Object)successfulSnapshotCount, (Object)totalSnapshotCount, (Object)this.maximumSnapshotCount);
                    return true;
                }
                logger.trace("[{}]: INELIGIBLE as it is not one of the {} oldest snapshots with {} non-failed snapshots ({} total), over the limit of {} maximum snapshots", (Object)snapName, (Object)snapsToDelete, (Object)successfulSnapshotCount, (Object)totalSnapshotCount, (Object)this.maximumSnapshotCount);
                return false;
            }
            if (this.minimumSnapshotCount != null && successfulSnapshotCount <= (long)this.minimumSnapshotCount.intValue()) {
                if (!unsuccessfulStates.contains(si.state())) {
                    logger.trace("[{}]: INELIGIBLE as there are {} non-failed snapshots ({} total) and {} minimum snapshots needed", (Object)snapName, (Object)successfulSnapshotCount, (Object)totalSnapshotCount, (Object)this.minimumSnapshotCount);
                    return false;
                }
                logger.trace("[{}]: SKIPPING minimum snapshot count check as this snapshot is {} and not counted towards the minimum snapshot count.", (Object)snapName, (Object)si.state());
            }
            if (this.expireAfter != null) {
                TimeValue snapshotAge = new TimeValue(this.nowSupplier.getAsLong() - si.startTime());
                if (this.minimumSnapshotCount != null) {
                    Stream<SnapshotInfo> unsucessfulSnaps;
                    long eligibleForExpiration = successfulSnapshotCount - (long)this.minimumSnapshotCount.intValue();
                    Stream<SnapshotInfo> successfulSnapsEligibleForExpiration = sortedSnapshots.stream().filter(snap -> SnapshotState.SUCCESS.equals((Object)snap.state())).limit(eligibleForExpiration);
                    Set snapsEligibleForExpiration = Stream.concat(successfulSnapsEligibleForExpiration, unsucessfulSnaps = sortedSnapshots.stream().filter(snap -> unsuccessfulStates.contains(snap.state()))).collect(Collectors.toSet());
                    if (!snapsEligibleForExpiration.contains(si)) {
                        logger.trace("[{}]: INELIGIBLE as snapshot expiration would pass the minimum number of configured snapshots ({}) to keep, regardless of age", (Object)snapName, (Object)this.minimumSnapshotCount);
                        return false;
                    }
                }
                if (snapshotAge.compareTo(this.expireAfter) > 0) {
                    logger.trace("[{}]: ELIGIBLE as snapshot age of {} is older than {}", (Object)snapName, (Object)snapshotAge.toHumanReadableString(3), (Object)this.expireAfter.toHumanReadableString(3));
                    return true;
                }
                logger.trace("[{}]: INELIGIBLE as snapshot age of {} is newer than {}", (Object)snapName, (Object)snapshotAge.toHumanReadableString(3), (Object)this.expireAfter.toHumanReadableString(3));
                return false;
            }
            logger.trace("[{}]: INELIGIBLE as no retention predicates matched", (Object)snapName);
            return false;
        };
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalTimeValue(this.expireAfter);
        out.writeOptionalVInt(this.minimumSnapshotCount);
        out.writeOptionalVInt(this.maximumSnapshotCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.expireAfter != null) {
            builder.field(EXPIRE_AFTER.getPreferredName(), this.expireAfter.getStringRep());
        }
        if (this.minimumSnapshotCount != null) {
            builder.field(MINIMUM_SNAPSHOT_COUNT.getPreferredName(), this.minimumSnapshotCount);
        }
        if (this.maximumSnapshotCount != null) {
            builder.field(MAXIMUM_SNAPSHOT_COUNT.getPreferredName(), this.maximumSnapshotCount);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.expireAfter, this.minimumSnapshotCount, this.maximumSnapshotCount);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotRetentionConfiguration other = (SnapshotRetentionConfiguration)obj;
        return Objects.equals(this.expireAfter, other.expireAfter) && Objects.equals(this.minimumSnapshotCount, other.minimumSnapshotCount) && Objects.equals(this.maximumSnapshotCount, other.maximumSnapshotCount);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), EXPIRE_AFTER);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MINIMUM_SNAPSHOT_COUNT);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAXIMUM_SNAPSHOT_COUNT);
    }
}

