/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.scheduler.Cron;
import org.elasticsearch.xpack.core.slm.SnapshotRetentionConfiguration;

public class SnapshotLifecyclePolicy
extends AbstractDiffable<SnapshotLifecyclePolicy>
implements Writeable,
Diffable<SnapshotLifecyclePolicy>,
ToXContentObject {
    public static final String POLICY_ID_METADATA_FIELD = "policy";
    private final String id;
    private final String name;
    private final String schedule;
    private final String repository;
    private final Map<String, Object> configuration;
    private final SnapshotRetentionConfiguration retentionPolicy;
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField SCHEDULE = new ParseField("schedule", new String[0]);
    private static final ParseField REPOSITORY = new ParseField("repository", new String[0]);
    private static final ParseField CONFIG = new ParseField("config", new String[0]);
    private static final ParseField RETENTION = new ParseField("retention", new String[0]);
    private static final IndexNameExpressionResolver.DateMathExpressionResolver DATE_MATH_RESOLVER = new IndexNameExpressionResolver.DateMathExpressionResolver();
    private static final String METADATA_FIELD_NAME = "metadata";
    private static final ConstructingObjectParser<SnapshotLifecyclePolicy, String> PARSER = new ConstructingObjectParser("snapshot_lifecycle", true, (a, id) -> {
        String name = (String)a[0];
        String schedule = (String)a[1];
        String repo = (String)a[2];
        Map config = (Map)a[3];
        SnapshotRetentionConfiguration retention = (SnapshotRetentionConfiguration)a[4];
        return new SnapshotLifecyclePolicy((String)id, name, schedule, repo, config, retention);
    });

    public SnapshotLifecyclePolicy(String id, String name, String schedule, String repository, @Nullable Map<String, Object> configuration, @Nullable SnapshotRetentionConfiguration retentionPolicy) {
        this.id = Objects.requireNonNull(id, "policy id is required");
        this.name = Objects.requireNonNull(name, "policy snapshot name is required");
        this.schedule = Objects.requireNonNull(schedule, "policy schedule is required");
        this.repository = Objects.requireNonNull(repository, "policy snapshot repository is required");
        this.configuration = configuration;
        this.retentionPolicy = retentionPolicy;
    }

    public SnapshotLifecyclePolicy(StreamInput in) throws IOException {
        this.id = in.readString();
        this.name = in.readString();
        this.schedule = in.readString();
        this.repository = in.readString();
        this.configuration = in.readMap();
        this.retentionPolicy = in.getVersion().onOrAfter(Version.V_7_5_0) ? (SnapshotRetentionConfiguration)in.readOptionalWriteable(SnapshotRetentionConfiguration::new) : SnapshotRetentionConfiguration.EMPTY;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getRepository() {
        return this.repository;
    }

    @Nullable
    public Map<String, Object> getConfig() {
        return this.configuration;
    }

    @Nullable
    public SnapshotRetentionConfiguration getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public long calculateNextExecution() {
        Cron schedule = new Cron(this.schedule);
        return schedule.getNextValidTimeAfter(System.currentTimeMillis());
    }

    public ActionRequestValidationException validate() {
        int byteCount;
        ActionRequestValidationException err = new ActionRequestValidationException();
        if (!Strings.validFileName((String)this.id)) {
            err.addValidationError("invalid policy id [" + this.id + "]: must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (this.id.charAt(0) == '_') {
            err.addValidationError("invalid policy id [" + this.id + "]: must not start with '_'");
        }
        if ((byteCount = this.id.getBytes(StandardCharsets.UTF_8).length) > 255) {
            err.addValidationError("invalid policy id [" + this.id + "]: name is too long, (" + byteCount + " > " + 255 + " bytes)");
        }
        String snapshotName = this.generateSnapshotName(new ResolverContext());
        if (!Strings.hasText((String)this.name)) {
            err.addValidationError("invalid snapshot name [" + this.name + "]: cannot be empty");
        }
        if (snapshotName.contains("#")) {
            err.addValidationError("invalid snapshot name [" + this.name + "]: must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            err.addValidationError("invalid snapshot name [" + this.name + "]: must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            err.addValidationError("invalid snapshot name [" + this.name + "]: must be lowercase");
        }
        if (!Strings.validFileName((String)snapshotName)) {
            err.addValidationError("invalid snapshot name [" + this.name + "]: must not contain contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (!Strings.hasText((String)this.schedule)) {
            err.addValidationError("invalid schedule [" + this.schedule + "]: must not be empty");
        } else {
            try {
                new Cron(this.schedule);
            }
            catch (IllegalArgumentException e) {
                err.addValidationError("invalid schedule: " + ExceptionsHelper.unwrapCause((Throwable)e).getMessage());
            }
        }
        if (this.configuration != null && this.configuration.containsKey(METADATA_FIELD_NAME)) {
            if (!(this.configuration.get(METADATA_FIELD_NAME) instanceof Map)) {
                err.addValidationError("invalid configuration.metadata [" + this.configuration.get(METADATA_FIELD_NAME) + "]: must be an object if present");
            } else {
                Map metadata = (Map)this.configuration.get(METADATA_FIELD_NAME);
                if (metadata.containsKey(POLICY_ID_METADATA_FIELD)) {
                    err.addValidationError("invalid configuration.metadata: field name [policy] is reserved and will be added automatically");
                } else {
                    Map<String, Object> metadataWithPolicyField = this.addPolicyNameToMetadata(metadata);
                    int serializedSizeOriginal = CreateSnapshotRequest.metadataSize((Map)metadata);
                    int serializedSizeWithMetadata = CreateSnapshotRequest.metadataSize(metadataWithPolicyField);
                    int policyNameAddedBytes = serializedSizeWithMetadata - serializedSizeOriginal;
                    if (serializedSizeWithMetadata > CreateSnapshotRequest.MAXIMUM_METADATA_BYTES) {
                        err.addValidationError("invalid configuration.metadata: must be smaller than [" + (CreateSnapshotRequest.MAXIMUM_METADATA_BYTES - policyNameAddedBytes) + "] bytes, but is [" + serializedSizeOriginal + "] bytes");
                    }
                }
            }
        }
        if (!Strings.hasText((String)this.repository)) {
            err.addValidationError("invalid repository name [" + this.repository + "]: cannot be empty");
        }
        return err.validationErrors().size() == 0 ? null : err;
    }

    private Map<String, Object> addPolicyNameToMetadata(Map<String, Object> metadata) {
        HashMap<Object, Object> newMetadata = metadata == null ? new HashMap() : new HashMap<String, Object>(metadata);
        newMetadata.put(POLICY_ID_METADATA_FIELD, this.id);
        return newMetadata;
    }

    public String generateSnapshotName(IndexNameExpressionResolver.Context context) {
        List candidates = DATE_MATH_RESOLVER.resolve(context, Collections.singletonList(this.name));
        if (candidates.size() != 1) {
            throw new IllegalStateException("resolving snapshot name " + this.name + " generated more than one candidate: " + candidates);
        }
        return (String)candidates.get(0) + "-" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
    }

    public CreateSnapshotRequest toRequest() {
        CreateSnapshotRequest req = new CreateSnapshotRequest(this.repository, this.generateSnapshotName(new ResolverContext()));
        Map metadata = (Map)this.configuration.get(METADATA_FIELD_NAME);
        Map<String, Object> metadataWithAddedPolicyName = this.addPolicyNameToMetadata(metadata);
        HashMap<String, Object> mergedConfiguration = new HashMap<String, Object>(this.configuration);
        mergedConfiguration.put(METADATA_FIELD_NAME, metadataWithAddedPolicyName);
        req.source(mergedConfiguration);
        req.waitForCompletion(true);
        return req;
    }

    public static SnapshotLifecyclePolicy parse(XContentParser parser, String id) {
        return (SnapshotLifecyclePolicy)((Object)PARSER.apply(parser, (Object)id));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeString(this.schedule);
        out.writeString(this.repository);
        out.writeMap(this.configuration);
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeOptionalWriteable((Writeable)this.retentionPolicy);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(SCHEDULE.getPreferredName(), this.schedule);
        builder.field(REPOSITORY.getPreferredName(), this.repository);
        if (this.configuration != null) {
            builder.field(CONFIG.getPreferredName(), this.configuration);
        }
        if (this.retentionPolicy != null) {
            builder.field(RETENTION.getPreferredName(), (ToXContent)this.retentionPolicy);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.schedule, this.repository, this.configuration, this.retentionPolicy);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        SnapshotLifecyclePolicy other = (SnapshotLifecyclePolicy)((Object)obj);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.repository, other.repository) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.retentionPolicy, other.retentionPolicy);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SCHEDULE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REPOSITORY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), CONFIG);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SnapshotRetentionConfiguration::parse, RETENTION);
    }

    public static final class ResolverContext
    extends IndexNameExpressionResolver.Context {
        public ResolverContext() {
            this(System.currentTimeMillis());
        }

        public ResolverContext(long startTime) {
            super(null, null, startTime, false, false);
        }

        public ClusterState getState() {
            throw new UnsupportedOperationException("should never be called");
        }

        public IndicesOptions getOptions() {
            throw new UnsupportedOperationException("should never be called");
        }
    }
}

