/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class RollupField {
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final String TASK_NAME = "xpack/rollup/job";
    public static final String ROLLUP_META = "_rollup";
    public static final String INTERVAL = "interval";
    public static final String COUNT_FIELD = "_count";
    public static final String VERSION_FIELD = "version";
    public static final String VALUE = "value";
    public static final String TIMESTAMP = "timestamp";
    public static final String FILTER = "filter";
    public static final String NAME = "rollup";
    public static final String TYPE_NAME = "_doc";
    public static final String AGG = "agg";
    public static final String ROLLUP_MISSING = "ROLLUP_MISSING_40710B25931745D4B0B8B310F6912A69";
    public static final List<String> SUPPORTED_NUMERIC_METRICS = Arrays.asList("max", "min", "sum", "avg", "value_count");
    public static final List<String> SUPPORTED_DATE_METRICS = Arrays.asList("max", "min", "value_count");
    public static final Set<String> SUPPORTED_METRICS = new HashSet<String>();
    public static final List<String> NUMERIC_FIELD_MAPPER_TYPES;
    public static final String DATE_FIELD_MAPPER_TYPE = "date";

    public static String formatFieldName(ValuesSourceAggregationBuilder<?, ?> source, String extra) {
        return source.field() + "." + source.getType() + "." + extra;
    }

    public static String formatFieldName(String field, String type, String extra) {
        return field + "." + type + "." + extra;
    }

    public static String formatMetaField(String extra) {
        return "_rollup." + extra;
    }

    public static String formatCountAggName(String field) {
        return field + "." + COUNT_FIELD;
    }

    public static String formatValueAggName(String field) {
        return field + "." + VALUE;
    }

    public static String formatComputed(String field, String agg) {
        return field + "." + agg;
    }

    public static String formatIndexerAggName(String field, String agg) {
        return field + "." + agg;
    }

    static {
        SUPPORTED_METRICS.addAll(SUPPORTED_NUMERIC_METRICS);
        SUPPORTED_METRICS.addAll(SUPPORTED_DATE_METRICS);
        List types = Stream.of(NumberFieldMapper.NumberType.values()).map(NumberFieldMapper.NumberType::typeName).collect(Collectors.toList());
        types.add("scaled_float");
        NUMERIC_FIELD_MAPPER_TYPES = types;
    }
}

