/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageRequestBuilder;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestXPackUsageAction
extends XPackRestHandler {
    public RestXPackUsageAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, URI_BASE + "/usage", (RestHandler)this);
    }

    public String getName() {
        return "xpack_usage_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) {
        TimeValue masterTimeout = request.paramAsTime("master_timeout", MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT);
        return channel -> ((XPackUsageRequestBuilder)new XPackUsageRequestBuilder((ElasticsearchClient)client.es()).setMasterNodeTimeout(masterTimeout)).execute((ActionListener)new RestBuilderListener<XPackUsageResponse>(channel){

            public RestResponse buildResponse(XPackUsageResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (XPackFeatureSet.Usage usage : response.getUsages()) {
                    builder.field(usage.name(), (ToXContent)usage);
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

