/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class DataCounts
implements ToXContentObject,
Writeable {
    private static final String DOCUMENT_SUFFIX = "_data_counts";
    public static final String PROCESSED_RECORD_COUNT_STR = "processed_record_count";
    public static final String PROCESSED_FIELD_COUNT_STR = "processed_field_count";
    public static final String INPUT_BYTES_STR = "input_bytes";
    public static final String INPUT_RECORD_COUNT_STR = "input_record_count";
    public static final String INPUT_FIELD_COUNT_STR = "input_field_count";
    public static final String INVALID_DATE_COUNT_STR = "invalid_date_count";
    public static final String MISSING_FIELD_COUNT_STR = "missing_field_count";
    public static final String OUT_OF_ORDER_TIME_COUNT_STR = "out_of_order_timestamp_count";
    public static final String EMPTY_BUCKET_COUNT_STR = "empty_bucket_count";
    public static final String SPARSE_BUCKET_COUNT_STR = "sparse_bucket_count";
    public static final String BUCKET_COUNT_STR = "bucket_count";
    public static final String EARLIEST_RECORD_TIME_STR = "earliest_record_timestamp";
    public static final String LATEST_RECORD_TIME_STR = "latest_record_timestamp";
    public static final String LAST_DATA_TIME_STR = "last_data_time";
    public static final String LATEST_EMPTY_BUCKET_TIME_STR = "latest_empty_bucket_timestamp";
    public static final String LATEST_SPARSE_BUCKET_TIME_STR = "latest_sparse_bucket_timestamp";
    public static final ParseField PROCESSED_RECORD_COUNT = new ParseField("processed_record_count", new String[0]);
    public static final ParseField PROCESSED_FIELD_COUNT = new ParseField("processed_field_count", new String[0]);
    public static final ParseField INPUT_BYTES = new ParseField("input_bytes", new String[0]);
    public static final ParseField INPUT_RECORD_COUNT = new ParseField("input_record_count", new String[0]);
    public static final ParseField INPUT_FIELD_COUNT = new ParseField("input_field_count", new String[0]);
    public static final ParseField INVALID_DATE_COUNT = new ParseField("invalid_date_count", new String[0]);
    public static final ParseField MISSING_FIELD_COUNT = new ParseField("missing_field_count", new String[0]);
    public static final ParseField OUT_OF_ORDER_TIME_COUNT = new ParseField("out_of_order_timestamp_count", new String[0]);
    public static final ParseField EMPTY_BUCKET_COUNT = new ParseField("empty_bucket_count", new String[0]);
    public static final ParseField SPARSE_BUCKET_COUNT = new ParseField("sparse_bucket_count", new String[0]);
    public static final ParseField BUCKET_COUNT = new ParseField("bucket_count", new String[0]);
    public static final ParseField EARLIEST_RECORD_TIME = new ParseField("earliest_record_timestamp", new String[0]);
    public static final ParseField LATEST_RECORD_TIME = new ParseField("latest_record_timestamp", new String[0]);
    public static final ParseField LAST_DATA_TIME = new ParseField("last_data_time", new String[0]);
    public static final ParseField LATEST_EMPTY_BUCKET_TIME = new ParseField("latest_empty_bucket_timestamp", new String[0]);
    public static final ParseField LATEST_SPARSE_BUCKET_TIME = new ParseField("latest_sparse_bucket_timestamp", new String[0]);
    public static final ParseField TYPE = new ParseField("data_counts", new String[0]);
    public static final ConstructingObjectParser<DataCounts, Void> PARSER = new ConstructingObjectParser("data_counts", true, a -> new DataCounts((String)a[0], (Long)a[1], (Long)a[2], (Long)a[3], (Long)a[4], (Long)a[5], (Long)a[6], (Long)a[7], (Long)a[8], (Long)a[9], (Long)a[10], (Date)a[11], (Date)a[12], (Date)a[13], (Date)a[14], (Date)a[15]));
    private final String jobId;
    private long processedRecordCount;
    private long processedFieldCount;
    private long inputBytes;
    private long inputFieldCount;
    private long invalidDateCount;
    private long missingFieldCount;
    private long outOfOrderTimeStampCount;
    private long emptyBucketCount;
    private long sparseBucketCount;
    private long bucketCount;
    private Date earliestRecordTimeStamp;
    private Date latestRecordTimeStamp;
    private Date lastDataTimeStamp;
    private Date latestEmptyBucketTimeStamp;
    private Date latestSparseBucketTimeStamp;

    public static String documentId(String jobId) {
        return jobId + DOCUMENT_SUFFIX;
    }

    public static String v54DocumentId(String jobId) {
        return jobId + "-data-counts";
    }

    public DataCounts(String jobId, long processedRecordCount, long processedFieldCount, long inputBytes, long inputFieldCount, long invalidDateCount, long missingFieldCount, long outOfOrderTimeStampCount, long emptyBucketCount, long sparseBucketCount, long bucketCount, Date earliestRecordTimeStamp, Date latestRecordTimeStamp, Date lastDataTimeStamp, Date latestEmptyBucketTimeStamp, Date latestSparseBucketTimeStamp) {
        this.jobId = jobId;
        this.processedRecordCount = processedRecordCount;
        this.processedFieldCount = processedFieldCount;
        this.inputBytes = inputBytes;
        this.inputFieldCount = inputFieldCount;
        this.invalidDateCount = invalidDateCount;
        this.missingFieldCount = missingFieldCount;
        this.outOfOrderTimeStampCount = outOfOrderTimeStampCount;
        this.emptyBucketCount = emptyBucketCount;
        this.sparseBucketCount = sparseBucketCount;
        this.bucketCount = bucketCount;
        this.latestRecordTimeStamp = latestRecordTimeStamp;
        this.earliestRecordTimeStamp = earliestRecordTimeStamp;
        this.lastDataTimeStamp = lastDataTimeStamp;
        this.latestEmptyBucketTimeStamp = latestEmptyBucketTimeStamp;
        this.latestSparseBucketTimeStamp = latestSparseBucketTimeStamp;
    }

    public DataCounts(String jobId) {
        this.jobId = jobId;
    }

    public DataCounts(DataCounts lhs) {
        this.jobId = lhs.jobId;
        this.processedRecordCount = lhs.processedRecordCount;
        this.processedFieldCount = lhs.processedFieldCount;
        this.inputBytes = lhs.inputBytes;
        this.inputFieldCount = lhs.inputFieldCount;
        this.invalidDateCount = lhs.invalidDateCount;
        this.missingFieldCount = lhs.missingFieldCount;
        this.outOfOrderTimeStampCount = lhs.outOfOrderTimeStampCount;
        this.emptyBucketCount = lhs.emptyBucketCount;
        this.sparseBucketCount = lhs.sparseBucketCount;
        this.bucketCount = lhs.bucketCount;
        this.latestRecordTimeStamp = lhs.latestRecordTimeStamp;
        this.earliestRecordTimeStamp = lhs.earliestRecordTimeStamp;
        this.lastDataTimeStamp = lhs.lastDataTimeStamp;
        this.latestEmptyBucketTimeStamp = lhs.latestEmptyBucketTimeStamp;
        this.latestSparseBucketTimeStamp = lhs.latestSparseBucketTimeStamp;
    }

    public DataCounts(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.processedRecordCount = in.readVLong();
        this.processedFieldCount = in.readVLong();
        this.inputBytes = in.readVLong();
        this.inputFieldCount = in.readVLong();
        this.invalidDateCount = in.readVLong();
        this.missingFieldCount = in.readVLong();
        this.outOfOrderTimeStampCount = in.readVLong();
        this.emptyBucketCount = in.readVLong();
        this.sparseBucketCount = in.readVLong();
        this.bucketCount = in.readVLong();
        if (in.readBoolean()) {
            this.latestRecordTimeStamp = new Date(in.readVLong());
        }
        if (in.readBoolean()) {
            this.earliestRecordTimeStamp = new Date(in.readVLong());
        }
        if (in.readBoolean()) {
            this.lastDataTimeStamp = new Date(in.readVLong());
        }
        if (in.readBoolean()) {
            this.latestEmptyBucketTimeStamp = new Date(in.readVLong());
        }
        if (in.readBoolean()) {
            this.latestSparseBucketTimeStamp = new Date(in.readVLong());
        }
        in.readVLong();
    }

    public String getJobid() {
        return this.jobId;
    }

    public long getProcessedRecordCount() {
        return this.processedRecordCount;
    }

    public void incrementProcessedRecordCount(long additional) {
        this.processedRecordCount += additional;
    }

    public long getProcessedFieldCount() {
        return this.processedFieldCount;
    }

    public void calcProcessedFieldCount(long analysisFieldsPerRecord) {
        this.processedFieldCount = this.processedRecordCount * analysisFieldsPerRecord - this.missingFieldCount;
        this.processedFieldCount = this.processedFieldCount < 0L ? 0L : this.processedFieldCount;
    }

    public long getInputRecordCount() {
        return this.processedRecordCount + this.outOfOrderTimeStampCount + this.invalidDateCount;
    }

    public long getInputBytes() {
        return this.inputBytes;
    }

    public void incrementInputBytes(long additional) {
        this.inputBytes += additional;
    }

    public long getInputFieldCount() {
        return this.inputFieldCount;
    }

    public void incrementInputFieldCount(long additional) {
        this.inputFieldCount += additional;
    }

    public long getInvalidDateCount() {
        return this.invalidDateCount;
    }

    public void incrementInvalidDateCount(long additional) {
        this.invalidDateCount += additional;
    }

    public long getMissingFieldCount() {
        return this.missingFieldCount;
    }

    public void incrementMissingFieldCount(long additional) {
        this.missingFieldCount += additional;
    }

    public long getOutOfOrderTimeStampCount() {
        return this.outOfOrderTimeStampCount;
    }

    public void incrementOutOfOrderTimeStampCount(long additional) {
        this.outOfOrderTimeStampCount += additional;
    }

    public long getEmptyBucketCount() {
        return this.emptyBucketCount;
    }

    public void incrementEmptyBucketCount(long additional) {
        this.emptyBucketCount += additional;
    }

    public long getSparseBucketCount() {
        return this.sparseBucketCount;
    }

    public void incrementSparseBucketCount(long additional) {
        this.sparseBucketCount += additional;
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public void incrementBucketCount(long additional) {
        this.bucketCount += additional;
    }

    public Date getEarliestRecordTimeStamp() {
        return this.earliestRecordTimeStamp;
    }

    public void setEarliestRecordTimeStamp(Date timeStamp) {
        if (this.earliestRecordTimeStamp != null) {
            throw new IllegalStateException("earliestRecordTimeStamp can only be set once");
        }
        this.earliestRecordTimeStamp = timeStamp;
    }

    public Date getLatestRecordTimeStamp() {
        return this.latestRecordTimeStamp;
    }

    public void setLatestRecordTimeStamp(Date latestRecordTimeStamp) {
        this.latestRecordTimeStamp = latestRecordTimeStamp;
    }

    public void updateLatestRecordTimeStamp(Date latestRecordTimeStamp) {
        if (latestRecordTimeStamp != null && (this.latestRecordTimeStamp == null || latestRecordTimeStamp.after(this.latestRecordTimeStamp))) {
            this.latestRecordTimeStamp = latestRecordTimeStamp;
        }
    }

    public Date getLastDataTimeStamp() {
        return this.lastDataTimeStamp;
    }

    public void setLastDataTimeStamp(Date lastDataTimeStamp) {
        this.lastDataTimeStamp = lastDataTimeStamp;
    }

    public Date getLatestEmptyBucketTimeStamp() {
        return this.latestEmptyBucketTimeStamp;
    }

    public void setLatestEmptyBucketTimeStamp(Date latestEmptyBucketTimeStamp) {
        this.latestEmptyBucketTimeStamp = latestEmptyBucketTimeStamp;
    }

    public void updateLatestEmptyBucketTimeStamp(Date latestEmptyBucketTimeStamp) {
        if (latestEmptyBucketTimeStamp != null && (this.latestEmptyBucketTimeStamp == null || latestEmptyBucketTimeStamp.after(this.latestEmptyBucketTimeStamp))) {
            this.latestEmptyBucketTimeStamp = latestEmptyBucketTimeStamp;
        }
    }

    public Date getLatestSparseBucketTimeStamp() {
        return this.latestSparseBucketTimeStamp;
    }

    public void setLatestSparseBucketTimeStamp(Date latestSparseBucketTimeStamp) {
        this.latestSparseBucketTimeStamp = latestSparseBucketTimeStamp;
    }

    public void updateLatestSparseBucketTimeStamp(Date latestSparseBucketTimeStamp) {
        if (latestSparseBucketTimeStamp != null && (this.latestSparseBucketTimeStamp == null || latestSparseBucketTimeStamp.after(this.latestSparseBucketTimeStamp))) {
            this.latestSparseBucketTimeStamp = latestSparseBucketTimeStamp;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeVLong(this.processedRecordCount);
        out.writeVLong(this.processedFieldCount);
        out.writeVLong(this.inputBytes);
        out.writeVLong(this.inputFieldCount);
        out.writeVLong(this.invalidDateCount);
        out.writeVLong(this.missingFieldCount);
        out.writeVLong(this.outOfOrderTimeStampCount);
        out.writeVLong(this.emptyBucketCount);
        out.writeVLong(this.sparseBucketCount);
        out.writeVLong(this.bucketCount);
        if (this.latestRecordTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestRecordTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.earliestRecordTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.earliestRecordTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.lastDataTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.lastDataTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.latestEmptyBucketTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestEmptyBucketTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.latestSparseBucketTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestSparseBucketTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeVLong(this.getInputRecordCount());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(PROCESSED_RECORD_COUNT.getPreferredName(), this.processedRecordCount);
        builder.field(PROCESSED_FIELD_COUNT.getPreferredName(), this.processedFieldCount);
        builder.field(INPUT_BYTES.getPreferredName(), this.inputBytes);
        builder.field(INPUT_FIELD_COUNT.getPreferredName(), this.inputFieldCount);
        builder.field(INVALID_DATE_COUNT.getPreferredName(), this.invalidDateCount);
        builder.field(MISSING_FIELD_COUNT.getPreferredName(), this.missingFieldCount);
        builder.field(OUT_OF_ORDER_TIME_COUNT.getPreferredName(), this.outOfOrderTimeStampCount);
        builder.field(EMPTY_BUCKET_COUNT.getPreferredName(), this.emptyBucketCount);
        builder.field(SPARSE_BUCKET_COUNT.getPreferredName(), this.sparseBucketCount);
        builder.field(BUCKET_COUNT.getPreferredName(), this.bucketCount);
        if (this.earliestRecordTimeStamp != null) {
            builder.timeField(EARLIEST_RECORD_TIME.getPreferredName(), EARLIEST_RECORD_TIME.getPreferredName() + "_string", this.earliestRecordTimeStamp.getTime());
        }
        if (this.latestRecordTimeStamp != null) {
            builder.timeField(LATEST_RECORD_TIME.getPreferredName(), LATEST_RECORD_TIME.getPreferredName() + "_string", this.latestRecordTimeStamp.getTime());
        }
        if (this.lastDataTimeStamp != null) {
            builder.timeField(LAST_DATA_TIME.getPreferredName(), LAST_DATA_TIME.getPreferredName() + "_string", this.lastDataTimeStamp.getTime());
        }
        if (this.latestEmptyBucketTimeStamp != null) {
            builder.timeField(LATEST_EMPTY_BUCKET_TIME.getPreferredName(), LATEST_EMPTY_BUCKET_TIME.getPreferredName() + "_string", this.latestEmptyBucketTimeStamp.getTime());
        }
        if (this.latestSparseBucketTimeStamp != null) {
            builder.timeField(LATEST_SPARSE_BUCKET_TIME.getPreferredName(), LATEST_SPARSE_BUCKET_TIME.getPreferredName() + "_string", this.latestSparseBucketTimeStamp.getTime());
        }
        builder.field(INPUT_RECORD_COUNT.getPreferredName(), this.getInputRecordCount());
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataCounts)) {
            return false;
        }
        DataCounts that = (DataCounts)other;
        return Objects.equals(this.jobId, that.jobId) && this.processedRecordCount == that.processedRecordCount && this.processedFieldCount == that.processedFieldCount && this.inputBytes == that.inputBytes && this.inputFieldCount == that.inputFieldCount && this.invalidDateCount == that.invalidDateCount && this.missingFieldCount == that.missingFieldCount && this.outOfOrderTimeStampCount == that.outOfOrderTimeStampCount && this.emptyBucketCount == that.emptyBucketCount && this.sparseBucketCount == that.sparseBucketCount && this.bucketCount == that.bucketCount && Objects.equals(this.latestRecordTimeStamp, that.latestRecordTimeStamp) && Objects.equals(this.earliestRecordTimeStamp, that.earliestRecordTimeStamp) && Objects.equals(this.lastDataTimeStamp, that.lastDataTimeStamp) && Objects.equals(this.latestEmptyBucketTimeStamp, that.latestEmptyBucketTimeStamp) && Objects.equals(this.latestSparseBucketTimeStamp, that.latestSparseBucketTimeStamp);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.processedRecordCount, this.processedFieldCount, this.inputBytes, this.inputFieldCount, this.invalidDateCount, this.missingFieldCount, this.outOfOrderTimeStampCount, this.lastDataTimeStamp, this.emptyBucketCount, this.sparseBucketCount, this.bucketCount, this.latestRecordTimeStamp, this.earliestRecordTimeStamp, this.latestEmptyBucketTimeStamp, this.latestSparseBucketTimeStamp);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PROCESSED_RECORD_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PROCESSED_FIELD_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INPUT_BYTES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INPUT_FIELD_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INVALID_DATE_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MISSING_FIELD_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), OUT_OF_ORDER_TIME_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), EMPTY_BUCKET_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), SPARSE_BUCKET_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_COUNT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeField(p, EARLIEST_RECORD_TIME.getPreferredName()), EARLIEST_RECORD_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeField(p, LATEST_RECORD_TIME.getPreferredName()), LATEST_RECORD_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeField(p, LAST_DATA_TIME.getPreferredName()), LAST_DATA_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeField(p, LATEST_EMPTY_BUCKET_TIME.getPreferredName()), LATEST_EMPTY_BUCKET_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeField(p, LATEST_SPARSE_BUCKET_TIME.getPreferredName()), LATEST_SPARSE_BUCKET_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareLong((t, u) -> {}, INPUT_RECORD_COUNT);
    }
}

