/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.utils;

import java.util.List;
import java.util.stream.Collectors;

public final class Statistics {
    private Statistics() {
    }

    public static List<Double> softMax(List<Double> values) {
        int i;
        Double expSum = 0.0;
        Double max = values.stream().filter(v -> !Statistics.isInvalid(v)).max(Double::compareTo).orElse(null);
        if (max == null) {
            throw new IllegalArgumentException("no valid values present");
        }
        List<Double> exps = values.stream().map(v -> Statistics.isInvalid(v) ? Double.NEGATIVE_INFINITY : v - max).collect(Collectors.toList());
        for (i = 0; i < exps.size(); ++i) {
            if (Statistics.isInvalid((Double)exps.get(i))) continue;
            Double exp = Math.exp(exps.get(i));
            expSum = expSum + exp;
            exps.set(i, exp);
        }
        for (i = 0; i < exps.size(); ++i) {
            if (Statistics.isInvalid(exps.get(i))) {
                exps.set(i, 0.0);
                continue;
            }
            exps.set(i, exps.get(i) / expSum);
        }
        return exps;
    }

    public static boolean isInvalid(Double v) {
        return v == null || Double.isInfinite(v) || Double.isNaN(v);
    }
}

