/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.tree;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Operator;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TreeNode
implements ToXContentObject,
Writeable {
    public static final String NAME = "tree_node";
    public static final ParseField DECISION_TYPE = new ParseField("decision_type", new String[0]);
    public static final ParseField THRESHOLD = new ParseField("threshold", new String[0]);
    public static final ParseField LEFT_CHILD = new ParseField("left_child", new String[0]);
    public static final ParseField RIGHT_CHILD = new ParseField("right_child", new String[0]);
    public static final ParseField DEFAULT_LEFT = new ParseField("default_left", new String[0]);
    public static final ParseField SPLIT_FEATURE = new ParseField("split_feature", new String[0]);
    public static final ParseField NODE_INDEX = new ParseField("node_index", new String[0]);
    public static final ParseField SPLIT_GAIN = new ParseField("split_gain", new String[0]);
    public static final ParseField LEAF_VALUE = new ParseField("leaf_value", new String[0]);
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = TreeNode.createParser(true);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = TreeNode.createParser(false);
    private final Operator operator;
    private final Double threshold;
    private final Integer splitFeature;
    private final int nodeIndex;
    private final Double splitGain;
    private final Double leafValue;
    private final boolean defaultLeft;
    private final int leftChild;
    private final int rightChild;

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME, lenient, () -> new Builder());
        parser.declareDouble(Builder::setThreshold, THRESHOLD);
        parser.declareField(Builder::setOperator, p -> Operator.fromString(p.text()), DECISION_TYPE, ObjectParser.ValueType.STRING);
        parser.declareInt(Builder::setLeftChild, LEFT_CHILD);
        parser.declareInt(Builder::setRightChild, RIGHT_CHILD);
        parser.declareBoolean(Builder::setDefaultLeft, DEFAULT_LEFT);
        parser.declareInt(Builder::setSplitFeature, SPLIT_FEATURE);
        parser.declareInt(Builder::setNodeIndex, NODE_INDEX);
        parser.declareDouble(Builder::setSplitGain, SPLIT_GAIN);
        parser.declareDouble(Builder::setLeafValue, LEAF_VALUE);
        return parser;
    }

    public static Builder fromXContent(XContentParser parser, boolean lenient) {
        return lenient ? (Builder)LENIENT_PARSER.apply(parser, null) : (Builder)STRICT_PARSER.apply(parser, null);
    }

    TreeNode(Operator operator, Double threshold, Integer splitFeature, Integer nodeIndex, Double splitGain, Double leafValue, Boolean defaultLeft, Integer leftChild, Integer rightChild) {
        this.operator = operator == null ? Operator.LTE : operator;
        this.threshold = threshold;
        this.splitFeature = splitFeature;
        this.nodeIndex = ExceptionsHelper.requireNonNull(nodeIndex, NODE_INDEX.getPreferredName());
        this.splitGain = splitGain;
        this.leafValue = leafValue;
        this.defaultLeft = defaultLeft == null ? false : defaultLeft;
        this.leftChild = leftChild == null ? -1 : leftChild;
        this.rightChild = rightChild == null ? -1 : rightChild;
    }

    public TreeNode(StreamInput in) throws IOException {
        this.operator = Operator.readFromStream(in);
        this.threshold = in.readOptionalDouble();
        this.splitFeature = in.readOptionalInt();
        this.splitGain = in.readOptionalDouble();
        this.nodeIndex = in.readInt();
        this.leafValue = in.readOptionalDouble();
        this.defaultLeft = in.readBoolean();
        this.leftChild = in.readInt();
        this.rightChild = in.readInt();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public Integer getSplitFeature() {
        return this.splitFeature;
    }

    public Integer getNodeIndex() {
        return this.nodeIndex;
    }

    public Double getSplitGain() {
        return this.splitGain;
    }

    public Double getLeafValue() {
        return this.leafValue;
    }

    public boolean isDefaultLeft() {
        return this.defaultLeft;
    }

    public int getLeftChild() {
        return this.leftChild;
    }

    public int getRightChild() {
        return this.rightChild;
    }

    public boolean isLeaf() {
        return this.leftChild < 0;
    }

    public int compare(List<Double> features) {
        if (this.isLeaf()) {
            throw new IllegalArgumentException("cannot call compare against a leaf node.");
        }
        Double feature = features.get(this.splitFeature);
        if (this.isMissing(feature)) {
            return this.defaultLeft ? this.leftChild : this.rightChild;
        }
        return this.operator.test(feature, this.threshold) ? this.leftChild : this.rightChild;
    }

    private boolean isMissing(Double feature) {
        return feature == null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.operator.writeTo(out);
        out.writeOptionalDouble(this.threshold);
        out.writeOptionalInt(this.splitFeature);
        out.writeOptionalDouble(this.splitGain);
        out.writeInt(this.nodeIndex);
        out.writeOptionalDouble(this.leafValue);
        out.writeBoolean(this.defaultLeft);
        out.writeInt(this.leftChild);
        out.writeInt(this.rightChild);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addOptionalField(builder, DECISION_TYPE, (Object)this.operator);
        this.addOptionalField(builder, THRESHOLD, this.threshold);
        this.addOptionalField(builder, SPLIT_FEATURE, this.splitFeature);
        this.addOptionalField(builder, SPLIT_GAIN, this.splitGain);
        builder.field(NODE_INDEX.getPreferredName(), this.nodeIndex);
        this.addOptionalField(builder, LEAF_VALUE, this.leafValue);
        builder.field(DEFAULT_LEFT.getPreferredName(), this.defaultLeft);
        if (this.leftChild >= 0) {
            builder.field(LEFT_CHILD.getPreferredName(), this.leftChild);
        }
        if (this.rightChild >= 0) {
            builder.field(RIGHT_CHILD.getPreferredName(), this.rightChild);
        }
        builder.endObject();
        return builder;
    }

    private void addOptionalField(XContentBuilder builder, ParseField field, Object value) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeNode that = (TreeNode)o;
        return Objects.equals((Object)this.operator, (Object)that.operator) && Objects.equals(this.threshold, that.threshold) && Objects.equals(this.splitFeature, that.splitFeature) && Objects.equals(this.nodeIndex, that.nodeIndex) && Objects.equals(this.splitGain, that.splitGain) && Objects.equals(this.leafValue, that.leafValue) && Objects.equals(this.defaultLeft, that.defaultLeft) && Objects.equals(this.leftChild, that.leftChild) && Objects.equals(this.rightChild, that.rightChild);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.threshold, this.splitFeature, this.splitGain, this.nodeIndex, this.leafValue, this.defaultLeft, this.leftChild, this.rightChild});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static Builder builder(int nodeIndex) {
        return new Builder(nodeIndex);
    }

    public static class Builder {
        private Operator operator;
        private Double threshold;
        private Integer splitFeature;
        private int nodeIndex;
        private Double splitGain;
        private Double leafValue;
        private Boolean defaultLeft;
        private Integer leftChild;
        private Integer rightChild;

        public Builder(int nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        private Builder() {
        }

        public Builder setOperator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public Builder setThreshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder setSplitFeature(Integer splitFeature) {
            this.splitFeature = splitFeature;
            return this;
        }

        public Builder setNodeIndex(Integer nodeIndex) {
            this.nodeIndex = nodeIndex;
            return this;
        }

        public Builder setSplitGain(Double splitGain) {
            this.splitGain = splitGain;
            return this;
        }

        public Builder setLeafValue(Double leafValue) {
            this.leafValue = leafValue;
            return this;
        }

        public Builder setDefaultLeft(Boolean defaultLeft) {
            this.defaultLeft = defaultLeft;
            return this;
        }

        public Builder setLeftChild(Integer leftChild) {
            this.leftChild = leftChild;
            return this;
        }

        Integer getLeftChild() {
            return this.leftChild;
        }

        public Builder setRightChild(Integer rightChild) {
            this.rightChild = rightChild;
            return this;
        }

        Integer getRightChild() {
            return this.rightChild;
        }

        public void validate() {
            if (this.nodeIndex < 0) {
                throw new IllegalArgumentException("[node_index] must be a non-negative integer.");
            }
            if (this.leftChild == null) {
                if (this.leafValue == null) {
                    throw new IllegalArgumentException("[leaf_value] is required for a leaf node.");
                }
            } else {
                if (this.leftChild < 0) {
                    throw new IllegalArgumentException("[left_child] must be a non-negative integer.");
                }
                if (this.rightChild != null && this.rightChild < 0) {
                    throw new IllegalArgumentException("[right_child] must be a non-negative integer.");
                }
                if (this.threshold == null) {
                    throw new IllegalArgumentException("[threshold] must exist for non-leaf node.");
                }
            }
        }

        public TreeNode build() {
            this.validate();
            return new TreeNode(this.operator, this.threshold, this.splitFeature, this.nodeIndex, this.splitGain, this.leafValue, this.defaultLeft, this.leftChild, this.rightChild);
        }
    }
}

