/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.tree;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CachedSupplier;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedTrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedTrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.tree.TreeNode;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Tree
implements LenientlyParsedTrainedModel,
StrictlyParsedTrainedModel {
    public static final ParseField NAME = new ParseField("tree", new String[0]);
    public static final ParseField FEATURE_NAMES = new ParseField("feature_names", new String[0]);
    public static final ParseField TREE_STRUCTURE = new ParseField("tree_structure", new String[0]);
    public static final ParseField TARGET_TYPE = new ParseField("target_type", new String[0]);
    public static final ParseField CLASSIFICATION_LABELS = new ParseField("classification_labels", new String[0]);
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = Tree.createParser(true);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = Tree.createParser(false);
    private final List<String> featureNames;
    private final List<TreeNode> nodes;
    private final TargetType targetType;
    private final List<String> classificationLabels;
    private final CachedSupplier<Double> highestOrderCategory;

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareStringArray(Builder::setFeatureNames, FEATURE_NAMES);
        parser.declareObjectArray(Builder::setNodes, (p, c) -> TreeNode.fromXContent(p, lenient), TREE_STRUCTURE);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setTargetType(x$0), TARGET_TYPE);
        parser.declareStringArray(Builder::setClassificationLabels, CLASSIFICATION_LABELS);
        return parser;
    }

    public static Tree fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public static Tree fromXContentLenient(XContentParser parser) {
        return ((Builder)LENIENT_PARSER.apply(parser, null)).build();
    }

    Tree(List<String> featureNames, List<TreeNode> nodes, TargetType targetType, List<String> classificationLabels) {
        this.featureNames = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(featureNames, FEATURE_NAMES));
        this.nodes = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(nodes, TREE_STRUCTURE));
        this.targetType = ExceptionsHelper.requireNonNull(targetType, TARGET_TYPE);
        this.classificationLabels = classificationLabels == null ? null : Collections.unmodifiableList(classificationLabels);
        this.highestOrderCategory = new CachedSupplier(() -> this.maxLeafValue());
    }

    public Tree(StreamInput in) throws IOException {
        this.featureNames = Collections.unmodifiableList(in.readStringList());
        this.nodes = Collections.unmodifiableList(in.readList(TreeNode::new));
        this.targetType = TargetType.fromStream(in);
        this.classificationLabels = in.readBoolean() ? Collections.unmodifiableList(in.readStringList()) : null;
        this.highestOrderCategory = new CachedSupplier(() -> this.maxLeafValue());
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    public List<TreeNode> getNodes() {
        return this.nodes;
    }

    @Override
    public double infer(Map<String, Object> fields) {
        List<Double> features = this.featureNames.stream().map(f -> fields.get(f) instanceof Number ? Double.valueOf(((Number)fields.get(f)).doubleValue()) : null).collect(Collectors.toList());
        return this.infer(features);
    }

    @Override
    public double infer(List<Double> features) {
        TreeNode node = this.nodes.get(0);
        while (!node.isLeaf()) {
            node = this.nodes.get(node.compare(features));
        }
        return node.getLeafValue();
    }

    public List<TreeNode> trace(List<Double> features) {
        ArrayList<TreeNode> visited = new ArrayList<TreeNode>();
        TreeNode node = this.nodes.get(0);
        visited.add(node);
        while (!node.isLeaf()) {
            node = this.nodes.get(node.compare(features));
            visited.add(node);
        }
        return visited;
    }

    @Override
    public TargetType targetType() {
        return this.targetType;
    }

    @Override
    public List<Double> classificationProbability(Map<String, Object> fields) {
        if (!(this.targetType == TargetType.CLASSIFICATION)) {
            throw new UnsupportedOperationException("Cannot determine classification probability with target_type [" + this.targetType.toString() + "]");
        }
        List<Double> features = this.featureNames.stream().map(f -> fields.get(f) instanceof Number ? Double.valueOf(((Number)fields.get(f)).doubleValue()) : null).collect(Collectors.toList());
        return this.classificationProbability(features);
    }

    @Override
    public List<Double> classificationProbability(List<Double> fields) {
        if (!(this.targetType == TargetType.CLASSIFICATION)) {
            throw new UnsupportedOperationException("Cannot determine classification probability with target_type [" + this.targetType.toString() + "]");
        }
        double label = this.infer(fields);
        assert (label == Math.rint(label));
        double maxCategory = (Double)this.highestOrderCategory.get();
        assert (maxCategory == Math.rint(maxCategory));
        ArrayList<Double> list = new ArrayList<Double>(Collections.nCopies(Double.valueOf(maxCategory + 1.0).intValue(), 0.0));
        list.set(Double.valueOf(label).intValue(), 1.0);
        return list;
    }

    @Override
    public List<String> classificationLabels() {
        return this.classificationLabels;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.featureNames);
        out.writeCollection(this.nodes);
        this.targetType.writeTo(out);
        out.writeBoolean(this.classificationLabels != null);
        if (this.classificationLabels != null) {
            out.writeStringCollection(this.classificationLabels);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FEATURE_NAMES.getPreferredName(), this.featureNames);
        builder.field(TREE_STRUCTURE.getPreferredName(), this.nodes);
        builder.field(TARGET_TYPE.getPreferredName(), this.targetType.toString());
        if (this.classificationLabels != null) {
            builder.field(CLASSIFICATION_LABELS.getPreferredName(), this.classificationLabels);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tree that = (Tree)o;
        return Objects.equals(this.featureNames, that.featureNames) && Objects.equals(this.nodes, that.nodes) && Objects.equals((Object)this.targetType, (Object)that.targetType) && Objects.equals(this.classificationLabels, that.classificationLabels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureNames, this.nodes, this.targetType, this.classificationLabels});
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        this.checkTargetType();
        this.detectMissingNodes();
        this.detectCycle();
    }

    private void checkTargetType() {
        if (this.targetType == TargetType.CLASSIFICATION != (this.classificationLabels != null)) {
            throw ExceptionsHelper.badRequestException("[target_type] should be [classification] if [classification_labels] is provided, and vice versa", new Object[0]);
        }
    }

    private void detectCycle() {
        if (this.nodes.isEmpty()) {
            return;
        }
        HashSet<Integer> visited = new HashSet<Integer>(this.nodes.size());
        ArrayDeque<Integer> toVisit = new ArrayDeque<Integer>(this.nodes.size());
        toVisit.add(0);
        while (!toVisit.isEmpty()) {
            Integer nodeIdx = (Integer)toVisit.remove();
            if (visited.contains(nodeIdx)) {
                throw ExceptionsHelper.badRequestException("[tree] contains cycle at node {}", nodeIdx);
            }
            visited.add(nodeIdx);
            TreeNode treeNode = this.nodes.get(nodeIdx);
            if (treeNode.getLeftChild() >= 0) {
                toVisit.add(treeNode.getLeftChild());
            }
            if (treeNode.getRightChild() < 0) continue;
            toVisit.add(treeNode.getRightChild());
        }
    }

    private void detectMissingNodes() {
        if (this.nodes.isEmpty()) {
            return;
        }
        ArrayList<Integer> missingNodes = new ArrayList<Integer>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            TreeNode currentNode = this.nodes.get(i);
            if (currentNode == null) continue;
            if (Tree.nodeMissing(currentNode.getLeftChild(), this.nodes)) {
                missingNodes.add(currentNode.getLeftChild());
            }
            if (!Tree.nodeMissing(currentNode.getRightChild(), this.nodes)) continue;
            missingNodes.add(currentNode.getRightChild());
        }
        if (!missingNodes.isEmpty()) {
            throw ExceptionsHelper.badRequestException("[tree] contains missing nodes {}", missingNodes);
        }
    }

    private static boolean nodeMissing(int nodeIdx, List<TreeNode> nodes) {
        return nodeIdx >= nodes.size();
    }

    private Double maxLeafValue() {
        return this.targetType == TargetType.CLASSIFICATION ? Double.valueOf(this.nodes.stream().filter(TreeNode::isLeaf).mapToDouble(TreeNode::getLeafValue).max().getAsDouble()) : null;
    }

    public static class Builder {
        private List<String> featureNames;
        private ArrayList<TreeNode.Builder> nodes;
        private int numNodes;
        private TargetType targetType = TargetType.REGRESSION;
        private List<String> classificationLabels;

        public Builder() {
            this.nodes = new ArrayList();
            this.nodes.add(null);
            this.addLeaf(0, 0.0);
            this.numNodes = 1;
        }

        public Builder setFeatureNames(List<String> featureNames) {
            this.featureNames = featureNames;
            return this;
        }

        public Builder setRoot(TreeNode.Builder root) {
            this.nodes.set(0, root);
            return this;
        }

        public Builder addNode(TreeNode.Builder node) {
            this.nodes.add(node);
            return this;
        }

        public Builder setNodes(List<TreeNode.Builder> nodes) {
            this.nodes = new ArrayList(ExceptionsHelper.requireNonNull(nodes, TREE_STRUCTURE.getPreferredName()));
            return this;
        }

        public Builder setNodes(TreeNode.Builder ... nodes) {
            return this.setNodes(Arrays.asList(nodes));
        }

        public Builder setTargetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder setClassificationLabels(List<String> classificationLabels) {
            this.classificationLabels = classificationLabels;
            return this;
        }

        private void setTargetType(String targetType) {
            this.targetType = TargetType.fromString(targetType);
        }

        TreeNode.Builder addJunction(int nodeIndex, int featureIndex, boolean isDefaultLeft, double decisionThreshold) {
            int leftChild = this.numNodes++;
            int rightChild = this.numNodes++;
            this.nodes.ensureCapacity(nodeIndex + 1);
            for (int i = this.nodes.size(); i < nodeIndex + 1; ++i) {
                this.nodes.add(null);
            }
            TreeNode.Builder node = TreeNode.builder(nodeIndex).setDefaultLeft(isDefaultLeft).setLeftChild(leftChild).setRightChild(rightChild).setSplitFeature(featureIndex).setThreshold(decisionThreshold);
            this.nodes.set(nodeIndex, node);
            while (this.nodes.size() <= rightChild) {
                this.nodes.add(null);
            }
            return node;
        }

        Builder addLeaf(int nodeIndex, double value) {
            for (int i = this.nodes.size(); i < nodeIndex + 1; ++i) {
                this.nodes.add(null);
            }
            this.nodes.set(nodeIndex, TreeNode.builder(nodeIndex).setLeafValue(value));
            return this;
        }

        public Tree build() {
            if (this.nodes.stream().anyMatch(Objects::isNull)) {
                throw ExceptionsHelper.badRequestException("[tree] cannot contain null nodes", new Object[0]);
            }
            return new Tree(this.featureNames, this.nodes.stream().map(TreeNode.Builder::build).collect(Collectors.toList()), this.targetType, this.classificationLabels);
        }
    }
}

