/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.LenientlyParsedOutputAggregator;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.StrictlyParsedOutputAggregator;

public class WeightedSum
implements StrictlyParsedOutputAggregator,
LenientlyParsedOutputAggregator {
    public static final ParseField NAME = new ParseField("weighted_sum", new String[0]);
    public static final ParseField WEIGHTS = new ParseField("weights", new String[0]);
    private static final ConstructingObjectParser<WeightedSum, Void> LENIENT_PARSER = WeightedSum.createParser(true);
    private static final ConstructingObjectParser<WeightedSum, Void> STRICT_PARSER = WeightedSum.createParser(false);
    private final List<Double> weights;

    private static ConstructingObjectParser<WeightedSum, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new WeightedSum((List)a[0]));
        parser.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), WEIGHTS);
        return parser;
    }

    public static WeightedSum fromXContentStrict(XContentParser parser) {
        return (WeightedSum)STRICT_PARSER.apply(parser, null);
    }

    public static WeightedSum fromXContentLenient(XContentParser parser) {
        return (WeightedSum)LENIENT_PARSER.apply(parser, null);
    }

    WeightedSum() {
        this.weights = null;
    }

    public WeightedSum(List<Double> weights) {
        this.weights = weights == null ? null : Collections.unmodifiableList(weights);
    }

    public WeightedSum(StreamInput in) throws IOException {
        this.weights = in.readBoolean() ? Collections.unmodifiableList(in.readList(StreamInput::readDouble)) : null;
    }

    @Override
    public List<Double> processValues(List<Double> values) {
        Objects.requireNonNull(values, "values must not be null");
        if (this.weights == null) {
            return values;
        }
        if (values.size() != this.weights.size()) {
            throw new IllegalArgumentException("values must be the same length as weights.");
        }
        return IntStream.range(0, this.weights.size()).mapToDouble(i -> (Double)values.get(i) * this.weights.get(i)).boxed().collect(Collectors.toList());
    }

    @Override
    public double aggregate(List<Double> values) {
        Objects.requireNonNull(values, "values must not be null");
        if (values.isEmpty()) {
            throw new IllegalArgumentException("values must not be empty");
        }
        Optional summation = values.stream().reduce(Double::sum);
        if (summation.isPresent()) {
            return (Double)summation.get();
        }
        throw new IllegalArgumentException("values must not contain null values");
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.weights != null);
        if (this.weights != null) {
            out.writeCollection(this.weights, StreamOutput::writeDouble);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weights != null) {
            builder.field(WEIGHTS.getPreferredName(), this.weights);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedSum that = (WeightedSum)o;
        return Objects.equals(this.weights, that.weights);
    }

    public int hashCode() {
        return Objects.hash(this.weights);
    }

    @Override
    public Integer expectedValueSize() {
        return this.weights == null ? null : Integer.valueOf(this.weights.size());
    }
}

