/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.LenientlyParsedOutputAggregator;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.StrictlyParsedOutputAggregator;
import org.elasticsearch.xpack.core.ml.inference.utils.Statistics;

public class WeightedMode
implements StrictlyParsedOutputAggregator,
LenientlyParsedOutputAggregator {
    public static final ParseField NAME = new ParseField("weighted_mode", new String[0]);
    public static final ParseField WEIGHTS = new ParseField("weights", new String[0]);
    private static final ConstructingObjectParser<WeightedMode, Void> LENIENT_PARSER = WeightedMode.createParser(true);
    private static final ConstructingObjectParser<WeightedMode, Void> STRICT_PARSER = WeightedMode.createParser(false);
    private final List<Double> weights;

    private static ConstructingObjectParser<WeightedMode, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new WeightedMode((List)a[0]));
        parser.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), WEIGHTS);
        return parser;
    }

    public static WeightedMode fromXContentStrict(XContentParser parser) {
        return (WeightedMode)STRICT_PARSER.apply(parser, null);
    }

    public static WeightedMode fromXContentLenient(XContentParser parser) {
        return (WeightedMode)LENIENT_PARSER.apply(parser, null);
    }

    WeightedMode() {
        this.weights = null;
    }

    public WeightedMode(List<Double> weights) {
        this.weights = weights == null ? null : Collections.unmodifiableList(weights);
    }

    public WeightedMode(StreamInput in) throws IOException {
        this.weights = in.readBoolean() ? Collections.unmodifiableList(in.readList(StreamInput::readDouble)) : null;
    }

    @Override
    public Integer expectedValueSize() {
        return this.weights == null ? null : Integer.valueOf(this.weights.size());
    }

    @Override
    public List<Double> processValues(List<Double> values) {
        Objects.requireNonNull(values, "values must not be null");
        if (this.weights != null && values.size() != this.weights.size()) {
            throw new IllegalArgumentException("values must be the same length as weights.");
        }
        ArrayList<Integer> freqArray = new ArrayList<Integer>();
        Integer maxVal = 0;
        for (Double value : values) {
            if (value == null) {
                throw new IllegalArgumentException("values must not contain null values");
            }
            if (Double.isNaN(value) || Double.isInfinite(value) || value < 0.0 || value != Math.rint(value)) {
                throw new IllegalArgumentException("values must be whole, non-infinite, and positive");
            }
            Integer integerValue = value.intValue();
            freqArray.add(integerValue);
            if (integerValue <= maxVal) continue;
            maxVal = integerValue;
        }
        ArrayList<Double> frequencies = new ArrayList<Double>(Collections.nCopies(maxVal + 1, Double.NEGATIVE_INFINITY));
        for (int i = 0; i < freqArray.size(); ++i) {
            Double weight = this.weights == null ? 1.0 : this.weights.get(i);
            Integer value = (Integer)freqArray.get(i);
            Double frequency = (Double)frequencies.get(value) == Double.NEGATIVE_INFINITY ? weight : (Double)frequencies.get(value) + weight;
            frequencies.set(value, frequency);
        }
        return Statistics.softMax(frequencies);
    }

    @Override
    public double aggregate(List<Double> values) {
        Objects.requireNonNull(values, "values must not be null");
        int bestValue = 0;
        double bestFreq = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) {
                throw new IllegalArgumentException("values must not contain null values");
            }
            if (!(values.get(i) > bestFreq)) continue;
            bestFreq = values.get(i);
            bestValue = i;
        }
        return bestValue;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.weights != null);
        if (this.weights != null) {
            out.writeCollection(this.weights, StreamOutput::writeDouble);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weights != null) {
            builder.field(WEIGHTS.getPreferredName(), this.weights);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedMode that = (WeightedMode)o;
        return Objects.equals(this.weights, that.weights);
    }

    public int hashCode() {
        return Objects.hash(this.weights);
    }
}

