/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedTrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedTrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.LenientlyParsedOutputAggregator;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.OutputAggregator;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.StrictlyParsedOutputAggregator;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.WeightedSum;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class Ensemble
implements LenientlyParsedTrainedModel,
StrictlyParsedTrainedModel {
    public static final ParseField NAME = new ParseField("ensemble", new String[0]);
    public static final ParseField FEATURE_NAMES = new ParseField("feature_names", new String[0]);
    public static final ParseField TRAINED_MODELS = new ParseField("trained_models", new String[0]);
    public static final ParseField AGGREGATE_OUTPUT = new ParseField("aggregate_output", new String[0]);
    public static final ParseField TARGET_TYPE = new ParseField("target_type", new String[0]);
    public static final ParseField CLASSIFICATION_LABELS = new ParseField("classification_labels", new String[0]);
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = Ensemble.createParser(true);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = Ensemble.createParser(false);
    private final List<String> featureNames;
    private final List<TrainedModel> models;
    private final OutputAggregator outputAggregator;
    private final TargetType targetType;
    private final List<String> classificationLabels;

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, () -> Builder.builderForParser());
        parser.declareStringArray(Builder::setFeatureNames, FEATURE_NAMES);
        parser.declareNamedObjects(Builder::setTrainedModels, (p, c, n) -> lenient ? (TrainedModel)p.namedObject(LenientlyParsedTrainedModel.class, n, null) : (TrainedModel)p.namedObject(StrictlyParsedTrainedModel.class, n, null), ensembleBuilder -> ((Builder)ensembleBuilder).setModelsAreOrdered(true), TRAINED_MODELS);
        parser.declareNamedObjects((rec$, x$0) -> ((Builder)rec$).setOutputAggregatorFromParser(x$0), (p, c, n) -> lenient ? (OutputAggregator)p.namedObject(LenientlyParsedOutputAggregator.class, n, null) : (OutputAggregator)p.namedObject(StrictlyParsedOutputAggregator.class, n, null), ensembleBuilder -> {}, AGGREGATE_OUTPUT);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setTargetType(x$0), TARGET_TYPE);
        parser.declareStringArray(Builder::setClassificationLabels, CLASSIFICATION_LABELS);
        return parser;
    }

    public static Ensemble fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public static Ensemble fromXContentLenient(XContentParser parser) {
        return ((Builder)LENIENT_PARSER.apply(parser, null)).build();
    }

    Ensemble(List<String> featureNames, List<TrainedModel> models, OutputAggregator outputAggregator, TargetType targetType, @Nullable List<String> classificationLabels) {
        this.featureNames = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(featureNames, FEATURE_NAMES));
        this.models = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(models, TRAINED_MODELS));
        this.outputAggregator = ExceptionsHelper.requireNonNull(outputAggregator, AGGREGATE_OUTPUT);
        this.targetType = ExceptionsHelper.requireNonNull(targetType, TARGET_TYPE);
        this.classificationLabels = classificationLabels == null ? null : Collections.unmodifiableList(classificationLabels);
    }

    public Ensemble(StreamInput in) throws IOException {
        this.featureNames = Collections.unmodifiableList(in.readStringList());
        this.models = Collections.unmodifiableList(in.readNamedWriteableList(TrainedModel.class));
        this.outputAggregator = (OutputAggregator)in.readNamedWriteable(OutputAggregator.class);
        this.targetType = TargetType.fromStream(in);
        this.classificationLabels = in.readBoolean() ? in.readStringList() : null;
    }

    @Override
    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    @Override
    public double infer(Map<String, Object> fields) {
        List<Double> processedInferences = this.inferAndProcess(fields);
        return this.outputAggregator.aggregate(processedInferences);
    }

    @Override
    public double infer(List<Double> fields) {
        throw new UnsupportedOperationException("Ensemble requires map containing field names and values");
    }

    @Override
    public TargetType targetType() {
        return this.targetType;
    }

    @Override
    public List<Double> classificationProbability(Map<String, Object> fields) {
        if (!(this.targetType == TargetType.CLASSIFICATION)) {
            throw new UnsupportedOperationException("Cannot determine classification probability with target_type [" + this.targetType.toString() + "]");
        }
        return this.inferAndProcess(fields);
    }

    @Override
    public List<Double> classificationProbability(List<Double> fields) {
        throw new UnsupportedOperationException("Ensemble requires map containing field names and values");
    }

    @Override
    public List<String> classificationLabels() {
        return this.classificationLabels;
    }

    private List<Double> inferAndProcess(Map<String, Object> fields) {
        List<Double> modelInferences = this.models.stream().map(m -> m.infer(fields)).collect(Collectors.toList());
        return this.outputAggregator.processValues(modelInferences);
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.featureNames);
        out.writeNamedWriteableList(this.models);
        out.writeNamedWriteable((NamedWriteable)this.outputAggregator);
        this.targetType.writeTo(out);
        out.writeBoolean(this.classificationLabels != null);
        if (this.classificationLabels != null) {
            out.writeStringCollection(this.classificationLabels);
        }
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FEATURE_NAMES.getPreferredName(), this.featureNames);
        NamedXContentObjectHelper.writeNamedObjects(builder, params, true, TRAINED_MODELS.getPreferredName(), this.models);
        NamedXContentObjectHelper.writeNamedObjects(builder, params, false, AGGREGATE_OUTPUT.getPreferredName(), Collections.singletonList(this.outputAggregator));
        builder.field(TARGET_TYPE.getPreferredName(), this.targetType.toString());
        if (this.classificationLabels != null) {
            builder.field(CLASSIFICATION_LABELS.getPreferredName(), this.classificationLabels);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ensemble that = (Ensemble)o;
        return Objects.equals(this.featureNames, that.featureNames) && Objects.equals(this.models, that.models) && Objects.equals((Object)this.targetType, (Object)that.targetType) && Objects.equals(this.classificationLabels, that.classificationLabels) && Objects.equals(this.outputAggregator, that.outputAggregator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureNames, this.models, this.outputAggregator, this.targetType, this.classificationLabels});
    }

    @Override
    public void validate() {
        if (this.outputAggregator.expectedValueSize() != null && this.outputAggregator.expectedValueSize().intValue() != this.models.size()) {
            throw ExceptionsHelper.badRequestException("[{}] expects value array of size [{}] but number of models is [{}]", AGGREGATE_OUTPUT.getPreferredName(), this.outputAggregator.expectedValueSize(), this.models.size());
        }
        if (this.targetType == TargetType.CLASSIFICATION != (this.classificationLabels != null)) {
            throw ExceptionsHelper.badRequestException("[target_type] should be [classification] if [classification_labels] is provided, and vice versa", new Object[0]);
        }
        this.models.forEach(TrainedModel::validate);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> featureNames;
        private List<TrainedModel> trainedModels;
        private OutputAggregator outputAggregator = new WeightedSum();
        private TargetType targetType = TargetType.REGRESSION;
        private List<String> classificationLabels;
        private boolean modelsAreOrdered;

        private Builder(boolean modelsAreOrdered) {
            this.modelsAreOrdered = modelsAreOrdered;
        }

        private static Builder builderForParser() {
            return new Builder(false);
        }

        public Builder() {
            this(true);
        }

        public Builder setFeatureNames(List<String> featureNames) {
            this.featureNames = featureNames;
            return this;
        }

        public Builder setTrainedModels(List<TrainedModel> trainedModels) {
            this.trainedModels = trainedModels;
            return this;
        }

        public Builder setOutputAggregator(OutputAggregator outputAggregator) {
            this.outputAggregator = ExceptionsHelper.requireNonNull(outputAggregator, AGGREGATE_OUTPUT);
            return this;
        }

        public Builder setTargetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder setClassificationLabels(List<String> classificationLabels) {
            this.classificationLabels = classificationLabels;
            return this;
        }

        private void setOutputAggregatorFromParser(List<OutputAggregator> outputAggregators) {
            if (outputAggregators.size() != 1) {
                throw ExceptionsHelper.badRequestException("[{}] must have exactly one aggregator defined.", AGGREGATE_OUTPUT.getPreferredName());
            }
            this.setOutputAggregator(outputAggregators.get(0));
        }

        private void setTargetType(String targetType) {
            this.targetType = TargetType.fromString(targetType);
        }

        private void setModelsAreOrdered(boolean value) {
            this.modelsAreOrdered = value;
        }

        public Ensemble build() {
            if (!this.modelsAreOrdered && this.trainedModels != null && this.trainedModels.size() > 1) {
                throw ExceptionsHelper.badRequestException("[trained_models] needs to be an array of objects", new Object[0]);
            }
            return new Ensemble(this.featureNames, this.trainedModels, this.outputAggregator, this.targetType, this.classificationLabels);
        }
    }
}

