/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TargetMeanEncoding
implements LenientlyParsedPreProcessor,
StrictlyParsedPreProcessor {
    public static final ParseField NAME = new ParseField("target_mean_encoding", new String[0]);
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField TARGET_MAP = new ParseField("target_map", new String[0]);
    public static final ParseField DEFAULT_VALUE = new ParseField("default_value", new String[0]);
    public static final ConstructingObjectParser<TargetMeanEncoding, Void> STRICT_PARSER = TargetMeanEncoding.createParser(false);
    public static final ConstructingObjectParser<TargetMeanEncoding, Void> LENIENT_PARSER = TargetMeanEncoding.createParser(true);
    private final String field;
    private final String featureName;
    private final Map<String, Double> meanMap;
    private final double defaultValue;

    private static ConstructingObjectParser<TargetMeanEncoding, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new TargetMeanEncoding((String)a[0], (String)a[1], (Map)a[2], (Double)a[3]));
        parser.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(HashMap::new, XContentParser::doubleValue), TARGET_MAP);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), DEFAULT_VALUE);
        return parser;
    }

    public static TargetMeanEncoding fromXContentStrict(XContentParser parser) {
        return (TargetMeanEncoding)STRICT_PARSER.apply(parser, null);
    }

    public static TargetMeanEncoding fromXContentLenient(XContentParser parser) {
        return (TargetMeanEncoding)LENIENT_PARSER.apply(parser, null);
    }

    public TargetMeanEncoding(String field, String featureName, Map<String, Double> meanMap, Double defaultValue) {
        this.field = ExceptionsHelper.requireNonNull(field, FIELD);
        this.featureName = ExceptionsHelper.requireNonNull(featureName, FEATURE_NAME);
        this.meanMap = Collections.unmodifiableMap(ExceptionsHelper.requireNonNull(meanMap, TARGET_MAP));
        this.defaultValue = ExceptionsHelper.requireNonNull(defaultValue, DEFAULT_VALUE);
    }

    public TargetMeanEncoding(StreamInput in) throws IOException {
        this.field = in.readString();
        this.featureName = in.readString();
        this.meanMap = Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readDouble));
        this.defaultValue = in.readDouble();
    }

    public String getField() {
        return this.field;
    }

    public Map<String, Double> getMeanMap() {
        return this.meanMap;
    }

    public Double getDefaultValue() {
        return this.defaultValue;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public void process(Map<String, Object> fields) {
        String value = (String)fields.get(this.field);
        if (value == null) {
            return;
        }
        fields.put(this.featureName, this.meanMap.getOrDefault(value, this.defaultValue));
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeString(this.featureName);
        out.writeMap(this.meanMap, StreamOutput::writeString, StreamOutput::writeDouble);
        out.writeDouble(this.defaultValue);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(FEATURE_NAME.getPreferredName(), this.featureName);
        builder.field(TARGET_MAP.getPreferredName(), this.meanMap);
        builder.field(DEFAULT_VALUE.getPreferredName(), this.defaultValue);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetMeanEncoding that = (TargetMeanEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.meanMap, that.meanMap) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.featureName, this.meanMap, this.defaultValue);
    }
}

