/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OneHotEncoding
implements LenientlyParsedPreProcessor,
StrictlyParsedPreProcessor {
    public static final ParseField NAME = new ParseField("one_hot_encoding", new String[0]);
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField HOT_MAP = new ParseField("hot_map", new String[0]);
    public static final ConstructingObjectParser<OneHotEncoding, Void> STRICT_PARSER = OneHotEncoding.createParser(false);
    public static final ConstructingObjectParser<OneHotEncoding, Void> LENIENT_PARSER = OneHotEncoding.createParser(true);
    private final String field;
    private final Map<String, String> hotMap;

    private static ConstructingObjectParser<OneHotEncoding, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new OneHotEncoding((String)a[0], (Map)a[1]));
        parser.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), HOT_MAP);
        return parser;
    }

    public static OneHotEncoding fromXContentStrict(XContentParser parser) {
        return (OneHotEncoding)STRICT_PARSER.apply(parser, null);
    }

    public static OneHotEncoding fromXContentLenient(XContentParser parser) {
        return (OneHotEncoding)LENIENT_PARSER.apply(parser, null);
    }

    public OneHotEncoding(String field, Map<String, String> hotMap) {
        this.field = ExceptionsHelper.requireNonNull(field, FIELD);
        this.hotMap = Collections.unmodifiableMap(ExceptionsHelper.requireNonNull(hotMap, HOT_MAP));
    }

    public OneHotEncoding(StreamInput in) throws IOException {
        this.field = in.readString();
        this.hotMap = Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readString));
    }

    public String getField() {
        return this.field;
    }

    public Map<String, String> getHotMap() {
        return this.hotMap;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public void process(Map<String, Object> fields) {
        String value = (String)fields.get(this.field);
        if (value == null) {
            return;
        }
        this.hotMap.forEach((val, col) -> {
            int encoding = value.equals(val) ? 1 : 0;
            fields.put((String)col, encoding);
        });
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeMap(this.hotMap, StreamOutput::writeString, StreamOutput::writeString);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(HOT_MAP.getPreferredName(), this.hotMap);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneHotEncoding that = (OneHotEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.hotMap, that.hotMap);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.hotMap);
    }
}

