/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedTrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedTrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class TrainedModelDefinition
implements ToXContentObject,
Writeable {
    public static final String NAME = "trained_mode_definition";
    public static final ParseField TRAINED_MODEL = new ParseField("trained_model", new String[0]);
    public static final ParseField PREPROCESSORS = new ParseField("preprocessors", new String[0]);
    public static final ParseField INPUT = new ParseField("input", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = TrainedModelDefinition.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = TrainedModelDefinition.createParser(false);
    private final TrainedModel trainedModel;
    private final List<PreProcessor> preProcessors;
    private final Input input;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(NAME, ignoreUnknownFields, Builder::new);
        parser.declareNamedObjects((rec$, x$0) -> ((Builder)rec$).setTrainedModel(x$0), (p, c, n) -> ignoreUnknownFields ? (TrainedModel)p.namedObject(LenientlyParsedTrainedModel.class, n, null) : (TrainedModel)p.namedObject(StrictlyParsedTrainedModel.class, n, null), modelDocBuilder -> {}, TRAINED_MODEL);
        parser.declareNamedObjects(Builder::setPreProcessors, (p, c, n) -> ignoreUnknownFields ? (PreProcessor)p.namedObject(LenientlyParsedPreProcessor.class, n, null) : (PreProcessor)p.namedObject(StrictlyParsedPreProcessor.class, n, null), trainedModelDefBuilder -> ((Builder)trainedModelDefBuilder).setProcessorsInOrder(true), PREPROCESSORS);
        parser.declareObject(Builder::setInput, (p, c) -> Input.fromXContent(p, ignoreUnknownFields), INPUT);
        return parser;
    }

    public static Builder fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (Builder)LENIENT_PARSER.parse(parser, null) : (Builder)STRICT_PARSER.parse(parser, null);
    }

    TrainedModelDefinition(TrainedModel trainedModel, List<PreProcessor> preProcessors, Input input) {
        this.trainedModel = ExceptionsHelper.requireNonNull(trainedModel, TRAINED_MODEL);
        this.preProcessors = preProcessors == null ? Collections.emptyList() : Collections.unmodifiableList(preProcessors);
        this.input = ExceptionsHelper.requireNonNull(input, INPUT);
    }

    public TrainedModelDefinition(StreamInput in) throws IOException {
        this.trainedModel = (TrainedModel)in.readNamedWriteable(TrainedModel.class);
        this.preProcessors = in.readNamedWriteableList(PreProcessor.class);
        this.input = new Input(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.trainedModel);
        out.writeNamedWriteableList(this.preProcessors);
        this.input.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        NamedXContentObjectHelper.writeNamedObjects(builder, params, false, TRAINED_MODEL.getPreferredName(), Collections.singletonList(this.trainedModel));
        NamedXContentObjectHelper.writeNamedObjects(builder, params, true, PREPROCESSORS.getPreferredName(), this.preProcessors);
        builder.field(INPUT.getPreferredName(), (ToXContent)this.input);
        builder.endObject();
        return builder;
    }

    public TrainedModel getTrainedModel() {
        return this.trainedModel;
    }

    public List<PreProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public Input getInput() {
        return this.input;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelDefinition that = (TrainedModelDefinition)o;
        return Objects.equals(this.trainedModel, that.trainedModel) && Objects.equals(this.input, that.input) && Objects.equals(this.preProcessors, that.preProcessors);
    }

    public int hashCode() {
        return Objects.hash(this.trainedModel, this.input, this.preProcessors);
    }

    public static class Input
    implements ToXContentObject,
    Writeable {
        public static final String NAME = "trained_mode_definition_input";
        public static final ParseField FIELD_NAMES = new ParseField("field_names", new String[0]);
        public static final ConstructingObjectParser<Input, Void> LENIENT_PARSER = Input.createParser(true);
        public static final ConstructingObjectParser<Input, Void> STRICT_PARSER = Input.createParser(false);
        private final List<String> fieldNames;

        private static ConstructingObjectParser<Input, Void> createParser(boolean ignoreUnknownFields) {
            ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new Input((List)a[0]));
            parser.declareStringArray(ConstructingObjectParser.constructorArg(), FIELD_NAMES);
            return parser;
        }

        public static Input fromXContent(XContentParser parser, boolean lenient) throws IOException {
            return lenient ? (Input)LENIENT_PARSER.parse(parser, null) : (Input)STRICT_PARSER.parse(parser, null);
        }

        public Input(List<String> fieldNames) {
            this.fieldNames = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(fieldNames, FIELD_NAMES));
        }

        public Input(StreamInput in) throws IOException {
            this.fieldNames = Collections.unmodifiableList(in.readStringList());
        }

        public List<String> getFieldNames() {
            return this.fieldNames;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.fieldNames);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FIELD_NAMES.getPreferredName(), this.fieldNames);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Input that = (Input)o;
            return Objects.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            return Objects.hash(this.fieldNames);
        }
    }

    public static class Builder {
        private List<PreProcessor> preProcessors;
        private TrainedModel trainedModel;
        private boolean processorsInOrder;
        private Input input;

        private static Builder builderForParser() {
            return new Builder(false);
        }

        private Builder(boolean processorsInOrder) {
            this.processorsInOrder = processorsInOrder;
        }

        public Builder() {
            this(true);
        }

        public Builder setPreProcessors(List<PreProcessor> preProcessors) {
            this.preProcessors = preProcessors;
            return this;
        }

        public Builder setTrainedModel(TrainedModel trainedModel) {
            this.trainedModel = trainedModel;
            return this;
        }

        public Builder setInput(Input input) {
            this.input = input;
            return this;
        }

        private Builder setTrainedModel(List<TrainedModel> trainedModel) {
            if (trainedModel.size() != 1) {
                throw ExceptionsHelper.badRequestException("[{}] must have exactly one trained model defined.", TRAINED_MODEL.getPreferredName());
            }
            return this.setTrainedModel(trainedModel.get(0));
        }

        private void setProcessorsInOrder(boolean value) {
            this.processorsInOrder = value;
        }

        public TrainedModelDefinition build() {
            if (this.preProcessors != null && this.preProcessors.size() > 1 && !this.processorsInOrder) {
                throw new IllegalArgumentException("preprocessors must be an array of preprocessor objects");
            }
            return new TrainedModelDefinition(this.trainedModel, this.preProcessors, this.input);
        }
    }
}

