/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelDefinition;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class TrainedModelConfig
implements ToXContentObject,
Writeable {
    public static final String NAME = "trained_model_doc";
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField CREATED_BY = new ParseField("created_by", new String[0]);
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField CREATED_TIME = new ParseField("created_time", new String[0]);
    public static final ParseField MODEL_VERSION = new ParseField("model_version", new String[0]);
    public static final ParseField DEFINITION = new ParseField("definition", new String[0]);
    public static final ParseField MODEL_TYPE = new ParseField("model_type", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = TrainedModelConfig.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = TrainedModelConfig.createParser(false);
    private final String modelId;
    private final String createdBy;
    private final Version version;
    private final String description;
    private final Instant createdTime;
    private final long modelVersion;
    private final String modelType;
    private final Map<String, Object> metadata;
    private final TrainedModelDefinition definition;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(NAME, ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setModelId, MODEL_ID);
        parser.declareString(Builder::setCreatedBy, CREATED_BY);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setVersion(x$0), VERSION);
        parser.declareString(Builder::setDescription, DESCRIPTION);
        parser.declareField(Builder::setCreatedTime, (p, c) -> TimeUtils.parseTimeFieldToInstant(p, CREATED_TIME.getPreferredName()), CREATED_TIME, ObjectParser.ValueType.VALUE);
        parser.declareLong(Builder::setModelVersion, MODEL_VERSION);
        parser.declareString(Builder::setModelType, MODEL_TYPE);
        parser.declareObject(Builder::setMetadata, (p, c) -> p.map(), METADATA);
        parser.declareObject(Builder::setDefinition, (p, c) -> TrainedModelDefinition.fromXContent(p, ignoreUnknownFields), DEFINITION);
        return parser;
    }

    public static Builder fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (Builder)LENIENT_PARSER.parse(parser, null) : (Builder)STRICT_PARSER.parse(parser, null);
    }

    public static String documentId(String modelId, long modelVersion) {
        return "trained_model_doc-" + modelId + "-" + modelVersion;
    }

    TrainedModelConfig(String modelId, String createdBy, Version version, String description, Instant createdTime, Long modelVersion, String modelType, TrainedModelDefinition definition, Map<String, Object> metadata) {
        this.modelId = ExceptionsHelper.requireNonNull(modelId, MODEL_ID);
        this.createdBy = ExceptionsHelper.requireNonNull(createdBy, CREATED_BY);
        this.version = ExceptionsHelper.requireNonNull(version, VERSION);
        this.createdTime = Instant.ofEpochMilli(ExceptionsHelper.requireNonNull(createdTime, CREATED_TIME).toEpochMilli());
        this.modelType = ExceptionsHelper.requireNonNull(modelType, MODEL_TYPE);
        this.definition = definition;
        this.description = description;
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        this.modelVersion = modelVersion == null ? 0L : modelVersion;
    }

    public TrainedModelConfig(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.createdBy = in.readString();
        this.version = Version.readVersion((StreamInput)in);
        this.description = in.readOptionalString();
        this.createdTime = in.readInstant();
        this.modelVersion = in.readVLong();
        this.modelType = in.readString();
        this.definition = (TrainedModelDefinition)in.readOptionalWriteable(TrainedModelDefinition::new);
        this.metadata = in.readMap();
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public long getModelVersion() {
        return this.modelVersion;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public TrainedModelDefinition getDefinition() {
        return this.definition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeString(this.createdBy);
        Version.writeVersion((Version)this.version, (StreamOutput)out);
        out.writeOptionalString(this.description);
        out.writeInstant(this.createdTime);
        out.writeVLong(this.modelVersion);
        out.writeString(this.modelType);
        out.writeOptionalWriteable((Writeable)this.definition);
        out.writeMap(this.metadata);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID.getPreferredName(), this.modelId);
        builder.field(CREATED_BY.getPreferredName(), this.createdBy);
        builder.field(VERSION.getPreferredName(), this.version.toString());
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        builder.timeField(CREATED_TIME.getPreferredName(), CREATED_TIME.getPreferredName() + "_string", this.createdTime.toEpochMilli());
        builder.field(MODEL_VERSION.getPreferredName(), this.modelVersion);
        builder.field(MODEL_TYPE.getPreferredName(), this.modelType);
        if (this.definition != null) {
            builder.field(DEFINITION.getPreferredName(), (ToXContent)this.definition);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelConfig that = (TrainedModelConfig)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.createdTime, that.createdTime) && Objects.equals(this.modelVersion, that.modelVersion) && Objects.equals(this.modelType, that.modelType) && Objects.equals(this.definition, that.definition) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.createdBy, this.version, this.createdTime, this.modelType, this.definition, this.description, this.metadata, this.modelVersion);
    }

    public static class Builder {
        private String modelId;
        private String createdBy;
        private Version version;
        private String description;
        private Instant createdTime;
        private Long modelVersion;
        private String modelType;
        private Map<String, Object> metadata;
        private TrainedModelDefinition.Builder definition;

        public Builder setModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        private Builder setVersion(String version) {
            return this.setVersion(Version.fromString((String)version));
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public Builder setModelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setDefinition(TrainedModelDefinition.Builder definition) {
            this.definition = definition;
            return this;
        }

        public void validate() {
            ExceptionsHelper.requireNonNull(this.definition, DEFINITION);
            ExceptionsHelper.requireNonNull(this.modelId, MODEL_ID);
            if (!MlStrings.isValidId(this.modelId)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", MODEL_ID.getPreferredName(), this.modelId), new Object[0]);
            }
            if (!MlStrings.hasValidLengthForId(this.modelId)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid {0}; ''{1}'' cannot contain more than {2} characters.", MODEL_ID.getPreferredName(), this.modelId, 64), new Object[0]);
            }
            if (this.version != null) {
                throw ExceptionsHelper.badRequestException("illegal to set [{}] at inference model creation", VERSION.getPreferredName());
            }
            if (this.createdBy != null) {
                throw ExceptionsHelper.badRequestException("illegal to set [{}] at inference model creation", CREATED_BY.getPreferredName());
            }
            if (this.createdTime != null) {
                throw ExceptionsHelper.badRequestException("illegal to set [{}] at inference model creation", CREATED_TIME.getPreferredName());
            }
        }

        public TrainedModelConfig build() {
            return new TrainedModelConfig(this.modelId, this.createdBy, this.version, this.description, this.createdTime, this.modelVersion, this.modelType, this.definition == null ? null : this.definition.build(), this.metadata);
        }

        public TrainedModelConfig build(Version version) {
            return new TrainedModelConfig(this.modelId, this.createdBy, version, this.description, Instant.now(), this.modelVersion, this.modelType, this.definition == null ? null : this.definition.build(), this.metadata);
        }
    }
}

