/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.ClassificationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.MulticlassConfusionMatrix;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Classification
implements Evaluation {
    public static final ParseField NAME = new ParseField("classification", new String[0]);
    private static final ParseField ACTUAL_FIELD = new ParseField("actual_field", new String[0]);
    private static final ParseField PREDICTED_FIELD = new ParseField("predicted_field", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    public static final ConstructingObjectParser<Classification, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new Classification((String)a[0], (String)a[1], (List)a[2]));
    private final String actualField;
    private final String predictedField;
    private final List<ClassificationMetric> metrics;

    public static Classification fromXContent(XContentParser parser) {
        return (Classification)PARSER.apply(parser, null);
    }

    public Classification(String actualField, String predictedField, @Nullable List<ClassificationMetric> metrics) {
        this.actualField = ExceptionsHelper.requireNonNull(actualField, ACTUAL_FIELD);
        this.predictedField = ExceptionsHelper.requireNonNull(predictedField, PREDICTED_FIELD);
        this.metrics = Classification.initMetrics(metrics);
    }

    public Classification(StreamInput in) throws IOException {
        this.actualField = in.readString();
        this.predictedField = in.readString();
        this.metrics = in.readNamedWriteableList(ClassificationMetric.class);
    }

    private static List<ClassificationMetric> initMetrics(@Nullable List<ClassificationMetric> parsedMetrics) {
        ArrayList<ClassificationMetric> metrics;
        ArrayList<ClassificationMetric> arrayList = metrics = parsedMetrics == null ? Classification.defaultMetrics() : new ArrayList<ClassificationMetric>(parsedMetrics);
        if (metrics.isEmpty()) {
            throw ExceptionsHelper.badRequestException("[{}] must have one or more metrics", NAME.getPreferredName());
        }
        Collections.sort(metrics, Comparator.comparing(EvaluationMetric::getName));
        return metrics;
    }

    private static List<ClassificationMetric> defaultMetrics() {
        return Arrays.asList(new MulticlassConfusionMatrix());
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public List<ClassificationMetric> getMetrics() {
        return this.metrics;
    }

    @Override
    public SearchSourceBuilder buildSearch(QueryBuilder userProvidedQueryBuilder) {
        ExceptionsHelper.requireNonNull(userProvidedQueryBuilder, "userProvidedQueryBuilder");
        SearchSourceBuilder searchSourceBuilder = this.newSearchSourceBuilder(Arrays.asList(this.actualField, this.predictedField), userProvidedQueryBuilder);
        for (ClassificationMetric metric : this.metrics) {
            List<AggregationBuilder> aggs = metric.aggs(this.actualField, this.predictedField);
            aggs.forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        }
        return searchSourceBuilder;
    }

    @Override
    public void process(SearchResponse searchResponse) {
        ExceptionsHelper.requireNonNull(searchResponse, "searchResponse");
        if (searchResponse.getHits().getTotalHits().value == 0L) {
            throw ExceptionsHelper.badRequestException("No documents found containing both [{}, {}] fields", this.actualField, this.predictedField);
        }
        for (ClassificationMetric metric : this.metrics) {
            metric.process(searchResponse.getAggregations());
        }
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.actualField);
        out.writeString(this.predictedField);
        out.writeNamedWriteableList(this.metrics);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTUAL_FIELD.getPreferredName(), this.actualField);
        builder.field(PREDICTED_FIELD.getPreferredName(), this.predictedField);
        builder.startObject(METRICS.getPreferredName());
        for (ClassificationMetric metric : this.metrics) {
            builder.field(metric.getWriteableName(), (ToXContent)metric);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classification that = (Classification)o;
        return Objects.equals(that.actualField, this.actualField) && Objects.equals(that.predictedField, this.predictedField) && Objects.equals(that.metrics, this.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.actualField, this.predictedField, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PREDICTED_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (ClassificationMetric)p.namedObject(ClassificationMetric.class, n, c), METRICS);
    }
}

