/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;

public interface Evaluation
extends ToXContentObject,
NamedWriteable {
    public String getName();

    public List<? extends EvaluationMetric> getMetrics();

    public SearchSourceBuilder buildSearch(QueryBuilder var1);

    default public SearchSourceBuilder newSearchSourceBuilder(List<String> requiredFields, QueryBuilder userProvidedQueryBuilder) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (String requiredField : requiredFields) {
            boolQuery.filter((QueryBuilder)QueryBuilders.existsQuery((String)requiredField));
        }
        boolQuery.filter(userProvidedQueryBuilder);
        return new SearchSourceBuilder().size(0).query((QueryBuilder)boolQuery);
    }

    public void process(SearchResponse var1);

    default public boolean hasAllResults() {
        return this.getMetrics().stream().map(EvaluationMetric::getResult).allMatch(Optional::isPresent);
    }

    default public List<EvaluationMetricResult> getResults() {
        return this.getMetrics().stream().map(EvaluationMetric::getResult).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

