/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.BoostedTreeParams;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Types;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Regression
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    public static final ParseField DEPENDENT_VARIABLE = new ParseField("dependent_variable", new String[0]);
    public static final ParseField PREDICTION_FIELD_NAME = new ParseField("prediction_field_name", new String[0]);
    public static final ParseField TRAINING_PERCENT = new ParseField("training_percent", new String[0]);
    private static final ConstructingObjectParser<Regression, Void> LENIENT_PARSER = Regression.createParser(true);
    private static final ConstructingObjectParser<Regression, Void> STRICT_PARSER = Regression.createParser(false);
    private final String dependentVariable;
    private final BoostedTreeParams boostedTreeParams;
    private final String predictionFieldName;
    private final double trainingPercent;

    private static ConstructingObjectParser<Regression, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new Regression((String)a[0], new BoostedTreeParams((Double)a[1], (Double)a[2], (Double)a[3], (Integer)a[4], (Double)a[5]), (String)a[6], (Double)a[7]));
        parser.declareString(ConstructingObjectParser.constructorArg(), DEPENDENT_VARIABLE);
        BoostedTreeParams.declareFields(parser);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTION_FIELD_NAME);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TRAINING_PERCENT);
        return parser;
    }

    public static Regression fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return ignoreUnknownFields ? (Regression)LENIENT_PARSER.apply(parser, null) : (Regression)STRICT_PARSER.apply(parser, null);
    }

    public Regression(String dependentVariable, BoostedTreeParams boostedTreeParams, @Nullable String predictionFieldName, @Nullable Double trainingPercent) {
        if (trainingPercent != null && (trainingPercent < 1.0 || trainingPercent > 100.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [1, 100]", TRAINING_PERCENT.getPreferredName());
        }
        this.dependentVariable = ExceptionsHelper.requireNonNull(dependentVariable, DEPENDENT_VARIABLE);
        this.boostedTreeParams = ExceptionsHelper.requireNonNull(boostedTreeParams, "boosted_tree_params");
        this.predictionFieldName = predictionFieldName == null ? dependentVariable + "_prediction" : predictionFieldName;
        this.trainingPercent = trainingPercent == null ? 100.0 : trainingPercent;
    }

    public Regression(String dependentVariable) {
        this(dependentVariable, new BoostedTreeParams(), null, null);
    }

    public Regression(StreamInput in) throws IOException {
        this.dependentVariable = in.readString();
        this.boostedTreeParams = new BoostedTreeParams(in);
        this.predictionFieldName = in.readOptionalString();
        this.trainingPercent = in.readDouble();
    }

    public String getDependentVariable() {
        return this.dependentVariable;
    }

    public String getPredictionFieldName() {
        return this.predictionFieldName;
    }

    public double getTrainingPercent() {
        return this.trainingPercent;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.dependentVariable);
        this.boostedTreeParams.writeTo(out);
        out.writeOptionalString(this.predictionFieldName);
        out.writeDouble(this.trainingPercent);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        this.boostedTreeParams.toXContent(builder, params);
        if (this.predictionFieldName != null) {
            builder.field(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        builder.field(TRAINING_PERCENT.getPreferredName(), this.trainingPercent);
        builder.endObject();
        return builder;
    }

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        params.putAll(this.boostedTreeParams.getParams());
        if (this.predictionFieldName != null) {
            params.put(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        return params;
    }

    @Override
    public boolean supportsCategoricalFields() {
        return true;
    }

    @Override
    public Set<String> getAllowedCategoricalTypes(String fieldName) {
        return Types.categorical();
    }

    @Override
    public List<RequiredField> getRequiredFields() {
        return Collections.singletonList(new RequiredField(this.dependentVariable, Types.numerical()));
    }

    @Override
    public Map<String, Long> getFieldCardinalityLimits() {
        return Collections.emptyMap();
    }

    @Override
    public boolean supportsMissingValues() {
        return true;
    }

    @Override
    public boolean persistsState() {
        return true;
    }

    @Override
    public String getStateDocId(String jobId) {
        return jobId + "_regression_state#1";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regression that = (Regression)o;
        return Objects.equals(this.dependentVariable, that.dependentVariable) && Objects.equals(this.boostedTreeParams, that.boostedTreeParams) && Objects.equals(this.predictionFieldName, that.predictionFieldName) && this.trainingPercent == that.trainingPercent;
    }

    public int hashCode() {
        return Objects.hash(this.dependentVariable, this.boostedTreeParams, this.predictionFieldName, this.trainingPercent);
    }
}

