/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OutlierDetection
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("outlier_detection", new String[0]);
    public static final ParseField N_NEIGHBORS = new ParseField("n_neighbors", new String[0]);
    public static final ParseField METHOD = new ParseField("method", new String[0]);
    public static final ParseField FEATURE_INFLUENCE_THRESHOLD = new ParseField("feature_influence_threshold", new String[0]);
    public static final ParseField COMPUTE_FEATURE_INFLUENCE = new ParseField("compute_feature_influence", new String[0]);
    public static final ParseField OUTLIER_FRACTION = new ParseField("outlier_fraction", new String[0]);
    public static final ParseField STANDARDIZATION_ENABLED = new ParseField("standardization_enabled", new String[0]);
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = OutlierDetection.createParser(true);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = OutlierDetection.createParser(false);
    @Nullable
    private final Integer nNeighbors;
    @Nullable
    private final Method method;
    @Nullable
    private final Double featureInfluenceThreshold;
    private final boolean computeFeatureInfluence;
    private final double outlierFraction;
    private final boolean standardizationEnabled;

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareInt(Builder::setNNeighbors, N_NEIGHBORS);
        parser.declareField(Builder::setMethod, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Method.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, METHOD, ObjectParser.ValueType.STRING);
        parser.declareDouble(Builder::setFeatureInfluenceThreshold, FEATURE_INFLUENCE_THRESHOLD);
        parser.declareBoolean(Builder::setComputeFeatureInfluence, COMPUTE_FEATURE_INFLUENCE);
        parser.declareDouble(Builder::setOutlierFraction, OUTLIER_FRACTION);
        parser.declareBoolean(Builder::setStandardizationEnabled, STANDARDIZATION_ENABLED);
        return parser;
    }

    public static OutlierDetection fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return ignoreUnknownFields ? ((Builder)LENIENT_PARSER.apply(parser, null)).build() : ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    private OutlierDetection(Integer nNeighbors, Method method, Double featureInfluenceThreshold, boolean computeFeatureInfluence, double outlierFraction, boolean standardizationEnabled) {
        if (nNeighbors != null && nNeighbors <= 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a positive integer", N_NEIGHBORS.getPreferredName());
        }
        if (featureInfluenceThreshold != null && (featureInfluenceThreshold < 0.0 || featureInfluenceThreshold > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be in [0, 1]", FEATURE_INFLUENCE_THRESHOLD.getPreferredName());
        }
        if (outlierFraction < 0.0 || outlierFraction > 1.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be in [0, 1]", OUTLIER_FRACTION.getPreferredName());
        }
        this.nNeighbors = nNeighbors;
        this.method = method;
        this.featureInfluenceThreshold = featureInfluenceThreshold;
        this.computeFeatureInfluence = computeFeatureInfluence;
        this.outlierFraction = outlierFraction;
        this.standardizationEnabled = standardizationEnabled;
    }

    public OutlierDetection(StreamInput in) throws IOException {
        this.nNeighbors = in.readOptionalVInt();
        this.method = in.readBoolean() ? (Method)in.readEnum(Method.class) : null;
        this.featureInfluenceThreshold = in.readOptionalDouble();
        if (in.getVersion().onOrAfter(Version.V_7_5_0)) {
            this.computeFeatureInfluence = in.readBoolean();
            this.outlierFraction = in.readDouble();
            this.standardizationEnabled = in.readBoolean();
        } else {
            this.computeFeatureInfluence = true;
            this.outlierFraction = 0.05;
            this.standardizationEnabled = true;
        }
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.nNeighbors);
        if (this.method != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.method);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalDouble(this.featureInfluenceThreshold);
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeBoolean(this.computeFeatureInfluence);
            out.writeDouble(this.outlierFraction);
            out.writeBoolean(this.standardizationEnabled);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.nNeighbors != null) {
            builder.field(N_NEIGHBORS.getPreferredName(), this.nNeighbors);
        }
        if (this.method != null) {
            builder.field(METHOD.getPreferredName(), (Object)this.method);
        }
        if (this.featureInfluenceThreshold != null) {
            builder.field(FEATURE_INFLUENCE_THRESHOLD.getPreferredName(), this.featureInfluenceThreshold);
        }
        builder.field(COMPUTE_FEATURE_INFLUENCE.getPreferredName(), this.computeFeatureInfluence);
        builder.field(OUTLIER_FRACTION.getPreferredName(), this.outlierFraction);
        builder.field(STANDARDIZATION_ENABLED.getPreferredName(), this.standardizationEnabled);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlierDetection that = (OutlierDetection)o;
        return Objects.equals(this.nNeighbors, that.nNeighbors) && Objects.equals((Object)this.method, (Object)that.method) && Objects.equals(this.featureInfluenceThreshold, that.featureInfluenceThreshold) && this.computeFeatureInfluence == that.computeFeatureInfluence && this.outlierFraction == that.outlierFraction && this.standardizationEnabled == that.standardizationEnabled;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nNeighbors, this.method, this.featureInfluenceThreshold, this.computeFeatureInfluence, this.outlierFraction, this.standardizationEnabled});
    }

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.nNeighbors != null) {
            params.put(N_NEIGHBORS.getPreferredName(), this.nNeighbors);
        }
        if (this.method != null) {
            params.put(METHOD.getPreferredName(), (Object)this.method);
        }
        if (this.featureInfluenceThreshold != null) {
            params.put(FEATURE_INFLUENCE_THRESHOLD.getPreferredName(), this.featureInfluenceThreshold);
        }
        params.put(COMPUTE_FEATURE_INFLUENCE.getPreferredName(), this.computeFeatureInfluence);
        params.put(OUTLIER_FRACTION.getPreferredName(), this.outlierFraction);
        params.put(STANDARDIZATION_ENABLED.getPreferredName(), this.standardizationEnabled);
        return params;
    }

    @Override
    public boolean supportsCategoricalFields() {
        return false;
    }

    @Override
    public Set<String> getAllowedCategoricalTypes(String fieldName) {
        return Collections.emptySet();
    }

    @Override
    public List<RequiredField> getRequiredFields() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Long> getFieldCardinalityLimits() {
        return Collections.emptyMap();
    }

    @Override
    public boolean supportsMissingValues() {
        return false;
    }

    @Override
    public boolean persistsState() {
        return false;
    }

    @Override
    public String getStateDocId(String jobId) {
        throw new UnsupportedOperationException("Outlier detection does not support state");
    }

    public static class Builder {
        private Integer nNeighbors;
        private Method method;
        private Double featureInfluenceThreshold;
        private boolean computeFeatureInfluence = true;
        private double outlierFraction = 0.05;
        private boolean standardizationEnabled = true;

        public Builder setNNeighbors(Integer nNeighbors) {
            this.nNeighbors = nNeighbors;
            return this;
        }

        public Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder setFeatureInfluenceThreshold(Double featureInfluenceThreshold) {
            this.featureInfluenceThreshold = featureInfluenceThreshold;
            return this;
        }

        public Builder setComputeFeatureInfluence(boolean computeFeatureInfluence) {
            this.computeFeatureInfluence = computeFeatureInfluence;
            return this;
        }

        public Builder setOutlierFraction(double outlierFraction) {
            this.outlierFraction = outlierFraction;
            return this;
        }

        public Builder setStandardizationEnabled(boolean standardizationEnabled) {
            this.standardizationEnabled = standardizationEnabled;
            return this;
        }

        public OutlierDetection build() {
            return new OutlierDetection(this.nNeighbors, this.method, this.featureInfluenceThreshold, this.computeFeatureInfluence, this.outlierFraction, this.standardizationEnabled);
        }
    }

    public static enum Method {
        LOF,
        LDOF,
        DISTANCE_KTH_NN,
        DISTANCE_KNN;


        public static Method fromString(String value) {
            return Method.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

