/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.BoostedTreeParams;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Types;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Classification
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("classification", new String[0]);
    public static final ParseField DEPENDENT_VARIABLE = new ParseField("dependent_variable", new String[0]);
    public static final ParseField PREDICTION_FIELD_NAME = new ParseField("prediction_field_name", new String[0]);
    public static final ParseField NUM_TOP_CLASSES = new ParseField("num_top_classes", new String[0]);
    public static final ParseField TRAINING_PERCENT = new ParseField("training_percent", new String[0]);
    private static final ConstructingObjectParser<Classification, Void> LENIENT_PARSER = Classification.createParser(true);
    private static final ConstructingObjectParser<Classification, Void> STRICT_PARSER = Classification.createParser(false);
    private static final Set<String> ALLOWED_DEPENDENT_VARIABLE_TYPES = Collections.unmodifiableSet(Stream.of(Types.categorical(), Types.discreteNumerical(), Types.bool()).flatMap(Collection::stream).collect(Collectors.toSet()));
    private static final int DEFAULT_NUM_TOP_CLASSES = 2;
    private final String dependentVariable;
    private final BoostedTreeParams boostedTreeParams;
    private final String predictionFieldName;
    private final int numTopClasses;
    private final double trainingPercent;

    private static ConstructingObjectParser<Classification, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new Classification((String)a[0], new BoostedTreeParams((Double)a[1], (Double)a[2], (Double)a[3], (Integer)a[4], (Double)a[5]), (String)a[6], (Integer)a[7], (Double)a[8]));
        parser.declareString(ConstructingObjectParser.constructorArg(), DEPENDENT_VARIABLE);
        BoostedTreeParams.declareFields(parser);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTION_FIELD_NAME);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_CLASSES);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TRAINING_PERCENT);
        return parser;
    }

    public static Classification fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return ignoreUnknownFields ? (Classification)LENIENT_PARSER.apply(parser, null) : (Classification)STRICT_PARSER.apply(parser, null);
    }

    public Classification(String dependentVariable, BoostedTreeParams boostedTreeParams, @Nullable String predictionFieldName, @Nullable Integer numTopClasses, @Nullable Double trainingPercent) {
        if (numTopClasses != null && (numTopClasses < 0 || numTopClasses > 1000)) {
            throw ExceptionsHelper.badRequestException("[{}] must be an integer in [0, 1000]", NUM_TOP_CLASSES.getPreferredName());
        }
        if (trainingPercent != null && (trainingPercent < 1.0 || trainingPercent > 100.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [1, 100]", TRAINING_PERCENT.getPreferredName());
        }
        this.dependentVariable = ExceptionsHelper.requireNonNull(dependentVariable, DEPENDENT_VARIABLE);
        this.boostedTreeParams = ExceptionsHelper.requireNonNull(boostedTreeParams, "boosted_tree_params");
        this.predictionFieldName = predictionFieldName == null ? dependentVariable + "_prediction" : predictionFieldName;
        this.numTopClasses = numTopClasses == null ? 2 : numTopClasses;
        this.trainingPercent = trainingPercent == null ? 100.0 : trainingPercent;
    }

    public Classification(String dependentVariable) {
        this(dependentVariable, new BoostedTreeParams(), null, null, null);
    }

    public Classification(StreamInput in) throws IOException {
        this.dependentVariable = in.readString();
        this.boostedTreeParams = new BoostedTreeParams(in);
        this.predictionFieldName = in.readOptionalString();
        this.numTopClasses = in.readOptionalVInt();
        this.trainingPercent = in.readDouble();
    }

    public String getDependentVariable() {
        return this.dependentVariable;
    }

    public String getPredictionFieldName() {
        return this.predictionFieldName;
    }

    public int getNumTopClasses() {
        return this.numTopClasses;
    }

    public double getTrainingPercent() {
        return this.trainingPercent;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.dependentVariable);
        this.boostedTreeParams.writeTo(out);
        out.writeOptionalString(this.predictionFieldName);
        out.writeOptionalVInt(Integer.valueOf(this.numTopClasses));
        out.writeDouble(this.trainingPercent);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        this.boostedTreeParams.toXContent(builder, params);
        builder.field(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        if (this.predictionFieldName != null) {
            builder.field(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        builder.field(TRAINING_PERCENT.getPreferredName(), this.trainingPercent);
        builder.endObject();
        return builder;
    }

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        params.putAll(this.boostedTreeParams.getParams());
        params.put(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        if (this.predictionFieldName != null) {
            params.put(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        return params;
    }

    @Override
    public boolean supportsCategoricalFields() {
        return true;
    }

    @Override
    public Set<String> getAllowedCategoricalTypes(String fieldName) {
        if (this.dependentVariable.equals(fieldName)) {
            return ALLOWED_DEPENDENT_VARIABLE_TYPES;
        }
        return Types.categorical();
    }

    @Override
    public List<RequiredField> getRequiredFields() {
        return Collections.singletonList(new RequiredField(this.dependentVariable, ALLOWED_DEPENDENT_VARIABLE_TYPES));
    }

    @Override
    public Map<String, Long> getFieldCardinalityLimits() {
        return Collections.singletonMap(this.dependentVariable, 2L);
    }

    @Override
    public boolean supportsMissingValues() {
        return true;
    }

    @Override
    public boolean persistsState() {
        return false;
    }

    @Override
    public String getStateDocId(String jobId) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classification that = (Classification)o;
        return Objects.equals(this.dependentVariable, that.dependentVariable) && Objects.equals(this.boostedTreeParams, that.boostedTreeParams) && Objects.equals(this.predictionFieldName, that.predictionFieldName) && Objects.equals(this.numTopClasses, that.numTopClasses) && this.trainingPercent == that.trainingPercent;
    }

    public int hashCode() {
        return Objects.hash(this.dependentVariable, this.boostedTreeParams, this.predictionFieldName, this.numTopClasses, this.trainingPercent);
    }
}

