/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class BoostedTreeParams
implements ToXContentFragment,
Writeable {
    static final String NAME = "boosted_tree_params";
    public static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    public static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    public static final ParseField ETA = new ParseField("eta", new String[0]);
    public static final ParseField MAXIMUM_NUMBER_TREES = new ParseField("maximum_number_trees", new String[0]);
    public static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    private final Double lambda;
    private final Double gamma;
    private final Double eta;
    private final Integer maximumNumberTrees;
    private final Double featureBagFraction;

    static void declareFields(AbstractObjectParser<?, Void> parser) {
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LAMBDA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), GAMMA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAXIMUM_NUMBER_TREES);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_BAG_FRACTION);
    }

    BoostedTreeParams(@Nullable Double lambda, @Nullable Double gamma, @Nullable Double eta, @Nullable Integer maximumNumberTrees, @Nullable Double featureBagFraction) {
        if (lambda != null && lambda < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", LAMBDA.getPreferredName());
        }
        if (gamma != null && gamma < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", GAMMA.getPreferredName());
        }
        if (eta != null && (eta < 0.001 || eta > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [0.001, 1]", ETA.getPreferredName());
        }
        if (maximumNumberTrees != null && (maximumNumberTrees <= 0 || maximumNumberTrees > 2000)) {
            throw ExceptionsHelper.badRequestException("[{}] must be an integer in [1, 2000]", MAXIMUM_NUMBER_TREES.getPreferredName());
        }
        if (featureBagFraction != null && (featureBagFraction <= 0.0 || featureBagFraction > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in (0, 1]", FEATURE_BAG_FRACTION.getPreferredName());
        }
        this.lambda = lambda;
        this.gamma = gamma;
        this.eta = eta;
        this.maximumNumberTrees = maximumNumberTrees;
        this.featureBagFraction = featureBagFraction;
    }

    BoostedTreeParams() {
        this(null, null, null, null, null);
    }

    BoostedTreeParams(StreamInput in) throws IOException {
        this.lambda = in.readOptionalDouble();
        this.gamma = in.readOptionalDouble();
        this.eta = in.readOptionalDouble();
        this.maximumNumberTrees = in.readOptionalVInt();
        this.featureBagFraction = in.readOptionalDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.lambda);
        out.writeOptionalDouble(this.gamma);
        out.writeOptionalDouble(this.eta);
        out.writeOptionalVInt(this.maximumNumberTrees);
        out.writeOptionalDouble(this.featureBagFraction);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.lambda != null) {
            builder.field(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            builder.field(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            builder.field(ETA.getPreferredName(), this.eta);
        }
        if (this.maximumNumberTrees != null) {
            builder.field(MAXIMUM_NUMBER_TREES.getPreferredName(), this.maximumNumberTrees);
        }
        if (this.featureBagFraction != null) {
            builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        return builder;
    }

    Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.lambda != null) {
            params.put(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            params.put(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            params.put(ETA.getPreferredName(), this.eta);
        }
        if (this.maximumNumberTrees != null) {
            params.put(MAXIMUM_NUMBER_TREES.getPreferredName(), this.maximumNumberTrees);
        }
        if (this.featureBagFraction != null) {
            params.put(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoostedTreeParams that = (BoostedTreeParams)o;
        return Objects.equals(this.lambda, that.lambda) && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.eta, that.eta) && Objects.equals(this.maximumNumberTrees, that.maximumNumberTrees) && Objects.equals(this.featureBagFraction, that.featureBagFraction);
    }

    public int hashCode() {
        return Objects.hash(this.lambda, this.gamma, this.eta, this.maximumNumberTrees, this.featureBagFraction);
    }
}

