/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.AggProvider;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DelayedDataCheckConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.QueryProvider;
import org.elasticsearch.xpack.core.ml.utils.XContentObjectTransformer;

public class DatafeedUpdate
implements Writeable,
ToXContentObject {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(DatafeedUpdate.class));
    private static final String DEPRECATION_MESSAGE_ON_JOB_ID_UPDATE = "The ability to update a datafeed's job_id is deprecated.";
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("datafeed_update", Builder::new);
    private final String id;
    private final String jobId;
    private final TimeValue queryDelay;
    private final TimeValue frequency;
    private final List<String> indices;
    private final QueryProvider queryProvider;
    private final AggProvider aggProvider;
    private final List<SearchSourceBuilder.ScriptField> scriptFields;
    private final Integer scrollSize;
    private final ChunkingConfig chunkingConfig;
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    private final Integer maxEmptySearches;

    private DatafeedUpdate(String id, String jobId, TimeValue queryDelay, TimeValue frequency, List<String> indices, QueryProvider queryProvider, AggProvider aggProvider, List<SearchSourceBuilder.ScriptField> scriptFields, Integer scrollSize, ChunkingConfig chunkingConfig, DelayedDataCheckConfig delayedDataCheckConfig, Integer maxEmptySearches) {
        this.id = id;
        this.jobId = jobId;
        this.queryDelay = queryDelay;
        this.frequency = frequency;
        this.indices = indices;
        this.queryProvider = queryProvider;
        this.aggProvider = aggProvider;
        this.scriptFields = scriptFields;
        this.scrollSize = scrollSize;
        this.chunkingConfig = chunkingConfig;
        this.delayedDataCheckConfig = delayedDataCheckConfig;
        this.maxEmptySearches = maxEmptySearches;
    }

    public DatafeedUpdate(StreamInput in) throws IOException {
        this.id = in.readString();
        this.jobId = in.readOptionalString();
        this.queryDelay = in.readOptionalTimeValue();
        this.frequency = in.readOptionalTimeValue();
        this.indices = in.readBoolean() ? in.readStringList() : null;
        if (in.getVersion().before(Version.V_7_0_0) && in.readBoolean()) {
            in.readStringList();
        }
        if (in.getVersion().before(Version.V_7_0_0)) {
            this.queryProvider = QueryProvider.fromParsedQuery((QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class));
            this.aggProvider = AggProvider.fromParsedAggs((AggregatorFactories.Builder)in.readOptionalWriteable(AggregatorFactories.Builder::new));
        } else {
            this.queryProvider = (QueryProvider)in.readOptionalWriteable(QueryProvider::fromStream);
            this.aggProvider = (AggProvider)in.readOptionalWriteable(AggProvider::fromStream);
        }
        this.scriptFields = in.readBoolean() ? in.readList(SearchSourceBuilder.ScriptField::new) : null;
        this.scrollSize = in.readOptionalVInt();
        this.chunkingConfig = (ChunkingConfig)in.readOptionalWriteable(ChunkingConfig::new);
        this.delayedDataCheckConfig = in.getVersion().onOrAfter(Version.V_6_6_0) ? (DelayedDataCheckConfig)in.readOptionalWriteable(DelayedDataCheckConfig::new) : null;
        this.maxEmptySearches = in.getVersion().onOrAfter(Version.V_7_5_0) ? in.readOptionalInt() : null;
    }

    public String getId() {
        return this.id;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalString(this.jobId);
        out.writeOptionalTimeValue(this.queryDelay);
        out.writeOptionalTimeValue(this.frequency);
        if (this.indices != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.indices);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeBoolean(true);
            out.writeStringCollection(Collections.emptyList());
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalNamedWriteable(this.queryProvider == null ? null : this.queryProvider.getParsedQuery());
            out.writeOptionalWriteable(this.aggProvider == null ? null : this.aggProvider.getParsedAggs());
        } else {
            out.writeOptionalWriteable((Writeable)this.queryProvider);
            out.writeOptionalWriteable((Writeable)this.aggProvider);
        }
        if (this.scriptFields != null) {
            out.writeBoolean(true);
            out.writeList(this.scriptFields);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalVInt(this.scrollSize);
        out.writeOptionalWriteable((Writeable)this.chunkingConfig);
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeOptionalWriteable((Writeable)this.delayedDataCheckConfig);
        }
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeOptionalInt(this.maxEmptySearches);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), this.id);
        this.addOptionalField(builder, Job.ID, this.jobId);
        if (this.queryDelay != null) {
            builder.field(DatafeedConfig.QUERY_DELAY.getPreferredName(), this.queryDelay.getStringRep());
        }
        if (this.frequency != null) {
            builder.field(DatafeedConfig.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        this.addOptionalField(builder, DatafeedConfig.INDICES, this.indices);
        if (this.queryProvider != null) {
            builder.field(DatafeedConfig.QUERY.getPreferredName(), this.queryProvider.getQuery());
        }
        if (this.aggProvider != null) {
            builder.field(DatafeedConfig.AGGREGATIONS.getPreferredName(), this.aggProvider.getAggs());
        }
        if (this.scriptFields != null) {
            builder.startObject(DatafeedConfig.SCRIPT_FIELDS.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        this.addOptionalField(builder, DatafeedConfig.SCROLL_SIZE, this.scrollSize);
        this.addOptionalField(builder, DatafeedConfig.CHUNKING_CONFIG, this.chunkingConfig);
        this.addOptionalField(builder, DatafeedConfig.DELAYED_DATA_CHECK_CONFIG, this.delayedDataCheckConfig);
        this.addOptionalField(builder, DatafeedConfig.MAX_EMPTY_SEARCHES, this.maxEmptySearches);
        builder.endObject();
        return builder;
    }

    private void addOptionalField(XContentBuilder builder, ParseField field, Object value) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    TimeValue getQueryDelay() {
        return this.queryDelay;
    }

    TimeValue getFrequency() {
        return this.frequency;
    }

    List<String> getIndices() {
        return this.indices;
    }

    Integer getScrollSize() {
        return this.scrollSize;
    }

    Map<String, Object> getQuery() {
        return this.queryProvider == null ? null : this.queryProvider.getQuery();
    }

    QueryBuilder getParsedQuery(NamedXContentRegistry namedXContentRegistry) throws IOException {
        return XContentObjectTransformer.queryBuilderTransformer(namedXContentRegistry).fromMap(this.queryProvider.getQuery(), new ArrayList<String>());
    }

    Map<String, Object> getAggregations() {
        return this.aggProvider == null ? null : this.aggProvider.getAggs();
    }

    AggregatorFactories.Builder getParsedAgg(NamedXContentRegistry namedXContentRegistry) throws IOException {
        return XContentObjectTransformer.aggregatorTransformer(namedXContentRegistry).fromMap(this.aggProvider.getAggs(), new ArrayList<String>());
    }

    boolean hasAggregations() {
        return this.getAggregations() != null && this.getAggregations().size() > 0;
    }

    List<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields == null ? Collections.emptyList() : this.scriptFields;
    }

    ChunkingConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    public DelayedDataCheckConfig getDelayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    public Integer getMaxEmptySearches() {
        return this.maxEmptySearches;
    }

    public DatafeedConfig apply(DatafeedConfig datafeedConfig, Map<String, String> headers) {
        if (!this.id.equals(datafeedConfig.getId())) {
            throw new IllegalArgumentException("Cannot apply update to datafeedConfig with different id");
        }
        DatafeedConfig.Builder builder = new DatafeedConfig.Builder(datafeedConfig);
        if (this.jobId != null) {
            if (datafeedConfig.getJobId() != null && !datafeedConfig.getJobId().equals(this.jobId)) {
                deprecationLogger.deprecated(DEPRECATION_MESSAGE_ON_JOB_ID_UPDATE, new Object[0]);
            }
            builder.setJobId(this.jobId);
        }
        if (this.queryDelay != null) {
            builder.setQueryDelay(this.queryDelay);
        }
        if (this.frequency != null) {
            builder.setFrequency(this.frequency);
        }
        if (this.indices != null) {
            builder.setIndices(this.indices);
        }
        if (this.queryProvider != null) {
            builder.setQueryProvider(this.queryProvider);
        }
        if (this.aggProvider != null) {
            DatafeedConfig.validateAggregations(this.aggProvider.getParsedAggs());
            builder.setAggProvider(this.aggProvider);
        }
        if (this.scriptFields != null) {
            builder.setScriptFields(this.scriptFields);
        }
        if (this.scrollSize != null) {
            builder.setScrollSize(this.scrollSize);
        }
        if (this.chunkingConfig != null) {
            builder.setChunkingConfig(this.chunkingConfig);
        }
        if (this.delayedDataCheckConfig != null) {
            builder.setDelayedDataCheckConfig(this.delayedDataCheckConfig);
        }
        if (this.maxEmptySearches != null) {
            builder.setMaxEmptySearches(this.maxEmptySearches);
        }
        if (!headers.isEmpty()) {
            Map<String, String> securityHeaders = headers.entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            builder.setHeaders(securityHeaders);
        }
        return builder.build();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatafeedUpdate)) {
            return false;
        }
        DatafeedUpdate that = (DatafeedUpdate)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.queryDelay, that.queryDelay) && Objects.equals(this.indices, that.indices) && Objects.equals(this.queryProvider, that.queryProvider) && Objects.equals(this.scrollSize, that.scrollSize) && Objects.equals(this.aggProvider, that.aggProvider) && Objects.equals(this.delayedDataCheckConfig, that.delayedDataCheckConfig) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.chunkingConfig, that.chunkingConfig) && Objects.equals(this.maxEmptySearches, that.maxEmptySearches);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobId, this.frequency, this.queryDelay, this.indices, this.queryProvider, this.scrollSize, this.aggProvider, this.scriptFields, this.chunkingConfig, this.delayedDataCheckConfig, this.maxEmptySearches);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    boolean isNoop(DatafeedConfig datafeed) {
        return !(this.frequency != null && !Objects.equals(this.frequency, datafeed.getFrequency()) || this.queryDelay != null && !Objects.equals(this.queryDelay, datafeed.getQueryDelay()) || this.indices != null && !Objects.equals(this.indices, datafeed.getIndices()) || this.queryProvider != null && !Objects.equals(this.queryProvider.getQuery(), datafeed.getQuery()) || this.scrollSize != null && !Objects.equals(this.scrollSize, datafeed.getScrollSize()) || this.aggProvider != null && !Objects.equals(this.aggProvider.getAggs(), datafeed.getAggregations()) || this.scriptFields != null && !Objects.equals(this.scriptFields, datafeed.getScriptFields()) || this.delayedDataCheckConfig != null && !Objects.equals(this.delayedDataCheckConfig, datafeed.getDelayedDataCheckConfig()) || this.chunkingConfig != null && !Objects.equals(this.chunkingConfig, datafeed.getChunkingConfig()) || this.maxEmptySearches != null && !Objects.equals(this.maxEmptySearches, datafeed.getMaxEmptySearches()) && (this.maxEmptySearches != -1 || datafeed.getMaxEmptySearches() != null));
    }

    static {
        PARSER.declareString(Builder::setId, DatafeedConfig.ID);
        PARSER.declareString(Builder::setJobId, Job.ID);
        PARSER.declareStringArray(Builder::setIndices, DatafeedConfig.INDEXES);
        PARSER.declareStringArray(Builder::setIndices, DatafeedConfig.INDICES);
        PARSER.declareString((builder, val) -> builder.setQueryDelay(TimeValue.parseTimeValue((String)val, (String)DatafeedConfig.QUERY_DELAY.getPreferredName())), DatafeedConfig.QUERY_DELAY);
        PARSER.declareString((builder, val) -> builder.setFrequency(TimeValue.parseTimeValue((String)val, (String)DatafeedConfig.FREQUENCY.getPreferredName())), DatafeedConfig.FREQUENCY);
        PARSER.declareObject(Builder::setQuery, (p, c) -> QueryProvider.fromXContent(p, false, "Datafeed query is not parsable"), DatafeedConfig.QUERY);
        PARSER.declareObject((rec$, x$0) -> ((Builder)rec$).setAggregationsSafe(x$0), (p, c) -> AggProvider.fromXContent(p, false), DatafeedConfig.AGGREGATIONS);
        PARSER.declareObject((rec$, x$0) -> ((Builder)rec$).setAggregationsSafe(x$0), (p, c) -> AggProvider.fromXContent(p, false), DatafeedConfig.AGGS);
        PARSER.declareObject(Builder::setScriptFields, (p, c) -> {
            ArrayList<SearchSourceBuilder.ScriptField> parsedScriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                parsedScriptFields.add(new SearchSourceBuilder.ScriptField(p));
            }
            parsedScriptFields.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            return parsedScriptFields;
        }, DatafeedConfig.SCRIPT_FIELDS);
        PARSER.declareInt(Builder::setScrollSize, DatafeedConfig.SCROLL_SIZE);
        PARSER.declareObject(Builder::setChunkingConfig, ChunkingConfig.STRICT_PARSER, DatafeedConfig.CHUNKING_CONFIG);
        PARSER.declareObject(Builder::setDelayedDataCheckConfig, DelayedDataCheckConfig.STRICT_PARSER, DatafeedConfig.DELAYED_DATA_CHECK_CONFIG);
        PARSER.declareInt(Builder::setMaxEmptySearches, DatafeedConfig.MAX_EMPTY_SEARCHES);
    }

    public static class Builder {
        private String id;
        private String jobId;
        private TimeValue queryDelay;
        private TimeValue frequency;
        private List<String> indices;
        private QueryProvider queryProvider;
        private AggProvider aggProvider;
        private List<SearchSourceBuilder.ScriptField> scriptFields;
        private Integer scrollSize;
        private ChunkingConfig chunkingConfig;
        private DelayedDataCheckConfig delayedDataCheckConfig;
        private Integer maxEmptySearches;

        public Builder() {
        }

        public Builder(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, DatafeedConfig.ID.getPreferredName());
        }

        public Builder(DatafeedUpdate config) {
            this.id = config.id;
            this.jobId = config.jobId;
            this.queryDelay = config.queryDelay;
            this.frequency = config.frequency;
            this.indices = config.indices;
            this.queryProvider = config.queryProvider;
            this.aggProvider = config.aggProvider;
            this.scriptFields = config.scriptFields;
            this.scrollSize = config.scrollSize;
            this.chunkingConfig = config.chunkingConfig;
            this.delayedDataCheckConfig = config.delayedDataCheckConfig;
            this.maxEmptySearches = config.maxEmptySearches;
        }

        public Builder setId(String datafeedId) {
            this.id = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
            return this;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setIndices(List<String> indices) {
            this.indices = indices;
            return this;
        }

        public Builder setQueryDelay(TimeValue queryDelay) {
            this.queryDelay = queryDelay;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder setQuery(QueryProvider queryProvider) {
            this.queryProvider = queryProvider;
            return this;
        }

        private Builder setAggregationsSafe(AggProvider aggProvider) {
            if (this.aggProvider != null) {
                throw ExceptionsHelper.badRequestException("Found two aggregation definitions: [aggs] and [aggregations]", new Object[0]);
            }
            this.setAggregations(aggProvider);
            return this;
        }

        public Builder setAggregations(AggProvider aggProvider) {
            this.aggProvider = aggProvider;
            return this;
        }

        public Builder setScriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
            ArrayList<SearchSourceBuilder.ScriptField> sorted = new ArrayList<SearchSourceBuilder.ScriptField>(scriptFields);
            sorted.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            this.scriptFields = sorted;
            return this;
        }

        public Builder setDelayedDataCheckConfig(DelayedDataCheckConfig delayedDataCheckConfig) {
            this.delayedDataCheckConfig = delayedDataCheckConfig;
            return this;
        }

        public Builder setScrollSize(int scrollSize) {
            this.scrollSize = scrollSize;
            return this;
        }

        public Builder setChunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
            return this;
        }

        public Builder setMaxEmptySearches(int maxEmptySearches) {
            if (maxEmptySearches < -1 || maxEmptySearches == 0) {
                String msg = Messages.getMessage("Invalid {0} value ''{1}'' in datafeed configuration", DatafeedConfig.MAX_EMPTY_SEARCHES.getPreferredName(), maxEmptySearches);
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            this.maxEmptySearches = maxEmptySearches;
            return this;
        }

        public DatafeedUpdate build() {
            return new DatafeedUpdate(this.id, this.jobId, this.queryDelay, this.frequency, this.indices, this.queryProvider, this.aggProvider, this.scriptFields, this.scrollSize, this.chunkingConfig, this.delayedDataCheckConfig, this.maxEmptySearches);
        }
    }
}

