/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;

public class KillProcessAction
extends ActionType<Response> {
    public static final KillProcessAction INSTANCE = new KillProcessAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/kill/process";

    private KillProcessAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable {
        private final boolean killed;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.killed = in.readBoolean();
        }

        public Response(boolean killed) {
            super(null, null);
            this.killed = killed;
        }

        public boolean isKilled() {
            return this.killed;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.killed);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.killed == response.killed;
        }

        public int hashCode() {
            return Objects.hash(this.killed);
        }
    }

    public static class Request
    extends JobTaskRequest<Request> {
        public Request(String jobId) {
            super(jobId);
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        RequestBuilder(ElasticsearchClient client, KillProcessAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }
}

