/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class EstimateMemoryUsageAction
extends ActionType<Response> {
    public static final EstimateMemoryUsageAction INSTANCE = new EstimateMemoryUsageAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/estimate_memory_usage";

    private EstimateMemoryUsageAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField TYPE = new ParseField("memory_usage_estimation_result", new String[0]);
        public static final ParseField EXPECTED_MEMORY_WITHOUT_DISK = new ParseField("expected_memory_without_disk", new String[0]);
        public static final ParseField EXPECTED_MEMORY_WITH_DISK = new ParseField("expected_memory_with_disk", new String[0]);
        static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), args -> new Response((ByteSizeValue)args[0], (ByteSizeValue)args[1]));
        private final ByteSizeValue expectedMemoryWithoutDisk;
        private final ByteSizeValue expectedMemoryWithDisk;

        public Response(@Nullable ByteSizeValue expectedMemoryWithoutDisk, @Nullable ByteSizeValue expectedMemoryWithDisk) {
            this.expectedMemoryWithoutDisk = expectedMemoryWithoutDisk;
            this.expectedMemoryWithDisk = expectedMemoryWithDisk;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.expectedMemoryWithoutDisk = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.expectedMemoryWithDisk = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
        }

        public ByteSizeValue getExpectedMemoryWithoutDisk() {
            return this.expectedMemoryWithoutDisk;
        }

        public ByteSizeValue getExpectedMemoryWithDisk() {
            return this.expectedMemoryWithDisk;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.expectedMemoryWithoutDisk);
            out.writeOptionalWriteable((Writeable)this.expectedMemoryWithDisk);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.expectedMemoryWithoutDisk != null) {
                builder.field(EXPECTED_MEMORY_WITHOUT_DISK.getPreferredName(), this.expectedMemoryWithoutDisk.getStringRep());
            }
            if (this.expectedMemoryWithDisk != null) {
                builder.field(EXPECTED_MEMORY_WITH_DISK.getPreferredName(), this.expectedMemoryWithDisk.getStringRep());
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            Response that = (Response)((Object)other);
            return Objects.equals(this.expectedMemoryWithoutDisk, that.expectedMemoryWithoutDisk) && Objects.equals(this.expectedMemoryWithDisk, that.expectedMemoryWithDisk);
        }

        public int hashCode() {
            return Objects.hash(this.expectedMemoryWithoutDisk, this.expectedMemoryWithDisk);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)EXPECTED_MEMORY_WITHOUT_DISK.getPreferredName()), EXPECTED_MEMORY_WITHOUT_DISK, ObjectParser.ValueType.VALUE);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)EXPECTED_MEMORY_WITH_DISK.getPreferredName()), EXPECTED_MEMORY_WITH_DISK, ObjectParser.ValueType.VALUE);
        }
    }
}

