/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;

public final class MlTasks {
    public static final String JOB_TASK_NAME = "xpack/ml/job";
    public static final String DATAFEED_TASK_NAME = "xpack/ml/datafeed";
    public static final String DATA_FRAME_ANALYTICS_TASK_NAME = "xpack/ml/data_frame/analytics";
    public static final String JOB_TASK_ID_PREFIX = "job-";
    public static final String DATAFEED_TASK_ID_PREFIX = "datafeed-";
    public static final String DATA_FRAME_ANALYTICS_TASK_ID_PREFIX = "data_frame_analytics-";
    public static final PersistentTasksCustomMetaData.Assignment AWAITING_UPGRADE = new PersistentTasksCustomMetaData.Assignment(null, "persistent task cannot be assigned while upgrade mode is enabled.");

    private MlTasks() {
    }

    public static String jobTaskId(String jobId) {
        return JOB_TASK_ID_PREFIX + jobId;
    }

    public static String datafeedTaskId(String datafeedId) {
        return DATAFEED_TASK_ID_PREFIX + datafeedId;
    }

    public static String dataFrameAnalyticsTaskId(String id) {
        return DATA_FRAME_ANALYTICS_TASK_ID_PREFIX + id;
    }

    public static String dataFrameAnalyticsIdFromTaskId(String taskId) {
        return taskId.replaceFirst(DATA_FRAME_ANALYTICS_TASK_ID_PREFIX, "");
    }

    @Nullable
    public static PersistentTasksCustomMetaData.PersistentTask<?> getJobTask(String jobId, @Nullable PersistentTasksCustomMetaData tasks) {
        return tasks == null ? null : tasks.getTask(MlTasks.jobTaskId(jobId));
    }

    @Nullable
    public static PersistentTasksCustomMetaData.PersistentTask<?> getDatafeedTask(String datafeedId, @Nullable PersistentTasksCustomMetaData tasks) {
        return tasks == null ? null : tasks.getTask(MlTasks.datafeedTaskId(datafeedId));
    }

    @Nullable
    public static PersistentTasksCustomMetaData.PersistentTask<?> getDataFrameAnalyticsTask(String analyticsId, @Nullable PersistentTasksCustomMetaData tasks) {
        return tasks == null ? null : tasks.getTask(MlTasks.dataFrameAnalyticsTaskId(analyticsId));
    }

    public static JobState getJobState(String jobId, @Nullable PersistentTasksCustomMetaData tasks) {
        PersistentTasksCustomMetaData.PersistentTask<?> task = MlTasks.getJobTask(jobId, tasks);
        if (task != null) {
            JobTaskState jobTaskState = (JobTaskState)task.getState();
            if (jobTaskState == null) {
                return JobState.OPENING;
            }
            return jobTaskState.getState();
        }
        return JobState.CLOSED;
    }

    public static JobState getJobStateModifiedForReassignments(String jobId, @Nullable PersistentTasksCustomMetaData tasks) {
        return MlTasks.getJobStateModifiedForReassignments(MlTasks.getJobTask(jobId, tasks));
    }

    public static JobState getJobStateModifiedForReassignments(@Nullable PersistentTasksCustomMetaData.PersistentTask<?> task) {
        if (task == null) {
            return JobState.CLOSED;
        }
        JobTaskState jobTaskState = (JobTaskState)task.getState();
        if (jobTaskState == null) {
            return JobState.OPENING;
        }
        JobState jobState = jobTaskState.getState();
        if (jobTaskState.isStatusStale(task)) {
            if (jobState == JobState.CLOSING) {
                return JobState.CLOSED;
            }
            if (jobState != JobState.FAILED) {
                return JobState.OPENING;
            }
        }
        return jobState;
    }

    public static DatafeedState getDatafeedState(String datafeedId, @Nullable PersistentTasksCustomMetaData tasks) {
        PersistentTasksCustomMetaData.PersistentTask<?> task = MlTasks.getDatafeedTask(datafeedId, tasks);
        if (task != null && task.getState() != null) {
            return (DatafeedState)task.getState();
        }
        return DatafeedState.STOPPED;
    }

    public static DataFrameAnalyticsState getDataFrameAnalyticsState(String analyticsId, @Nullable PersistentTasksCustomMetaData tasks) {
        PersistentTasksCustomMetaData.PersistentTask<?> task = MlTasks.getDataFrameAnalyticsTask(analyticsId, tasks);
        return MlTasks.getDataFrameAnalyticsState(task);
    }

    public static DataFrameAnalyticsState getDataFrameAnalyticsState(@Nullable PersistentTasksCustomMetaData.PersistentTask<?> task) {
        if (task == null) {
            return DataFrameAnalyticsState.STOPPED;
        }
        DataFrameAnalyticsTaskState taskState = (DataFrameAnalyticsTaskState)task.getState();
        if (taskState == null) {
            return DataFrameAnalyticsState.STARTING;
        }
        DataFrameAnalyticsState state = taskState.getState();
        if (taskState.isStatusStale(task)) {
            if (state == DataFrameAnalyticsState.STOPPING) {
                return DataFrameAnalyticsState.STOPPED;
            }
            if (state != DataFrameAnalyticsState.FAILED) {
                return DataFrameAnalyticsState.STARTING;
            }
        }
        return state;
    }

    public static Set<String> openJobIds(@Nullable PersistentTasksCustomMetaData tasks) {
        if (tasks == null) {
            return Collections.emptySet();
        }
        return tasks.findTasks(JOB_TASK_NAME, task -> true).stream().map(t -> t.getId().substring(JOB_TASK_ID_PREFIX.length())).collect(Collectors.toSet());
    }

    public static Set<String> unassignedJobIds(@Nullable PersistentTasksCustomMetaData tasks, DiscoveryNodes nodes) {
        return MlTasks.unassignedJobTasks(tasks, nodes).stream().map(task -> task.getId().substring(JOB_TASK_ID_PREFIX.length())).collect(Collectors.toSet());
    }

    public static Collection<PersistentTasksCustomMetaData.PersistentTask<?>> unassignedJobTasks(@Nullable PersistentTasksCustomMetaData tasks, DiscoveryNodes nodes) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(JOB_TASK_NAME, task -> PersistentTasksClusterService.needsReassignment((PersistentTasksCustomMetaData.Assignment)task.getAssignment(), (DiscoveryNodes)nodes));
    }

    public static Set<String> startedDatafeedIds(@Nullable PersistentTasksCustomMetaData tasks) {
        if (tasks == null) {
            return Collections.emptySet();
        }
        return tasks.findTasks(DATAFEED_TASK_NAME, task -> true).stream().map(t -> t.getId().substring(DATAFEED_TASK_ID_PREFIX.length())).collect(Collectors.toSet());
    }

    public static Set<String> unassignedDatafeedIds(@Nullable PersistentTasksCustomMetaData tasks, DiscoveryNodes nodes) {
        return MlTasks.unassignedDatafeedTasks(tasks, nodes).stream().map(task -> task.getId().substring(DATAFEED_TASK_ID_PREFIX.length())).collect(Collectors.toSet());
    }

    public static Collection<PersistentTasksCustomMetaData.PersistentTask<?>> unassignedDatafeedTasks(@Nullable PersistentTasksCustomMetaData tasks, DiscoveryNodes nodes) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(DATAFEED_TASK_NAME, task -> PersistentTasksClusterService.needsReassignment((PersistentTasksCustomMetaData.Assignment)task.getAssignment(), (DiscoveryNodes)nodes));
    }
}

