/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class ShrinkSetAliasStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "aliases";
    private String shrunkIndexPrefix;

    public ShrinkSetAliasStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, String shrunkIndexPrefix) {
        super(key, nextStepKey, client);
        this.shrunkIndexPrefix = shrunkIndexPrefix;
    }

    String getShrunkIndexPrefix() {
        return this.shrunkIndexPrefix;
    }

    @Override
    public void performDuringNoSnapshot(IndexMetaData indexMetaData, ClusterState currentState, AsyncActionStep.Listener listener) {
        String index = indexMetaData.getIndex().getName();
        String targetIndexName = this.shrunkIndexPrefix + index;
        IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.removeIndex().index(index)).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(targetIndexName).alias(index));
        indexMetaData.getAliases().values().spliterator().forEachRemaining(aliasMetaDataObjectCursor -> {
            AliasMetaData aliasMetaDataToAdd = (AliasMetaData)aliasMetaDataObjectCursor.value;
            aliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(targetIndexName).alias(aliasMetaDataToAdd.alias()).indexRouting(aliasMetaDataToAdd.indexRouting()).searchRouting(aliasMetaDataToAdd.searchRouting()).filter(aliasMetaDataToAdd.filter() == null ? null : aliasMetaDataToAdd.filter().string()).writeIndex(null));
        });
        this.getClient().admin().indices().aliases(aliasesRequest, ActionListener.wrap(response -> listener.onResponse(true), listener::onFailure));
    }

    @Override
    public boolean indexSurvives() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shrunkIndexPrefix);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShrinkSetAliasStep other = (ShrinkSetAliasStep)obj;
        return super.equals(obj) && Objects.equals(this.shrunkIndexPrefix, other.shrunkIndexPrefix);
    }
}

