/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.RolloverStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateRolloverLifecycleDateStep;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;
import org.elasticsearch.xpack.core.ilm.WaitForRolloverReadyStep;

public class RolloverAction
implements LifecycleAction {
    public static final String NAME = "rollover";
    public static final String INDEXING_COMPLETE_STEP_NAME = "set-indexing-complete";
    public static final ParseField MAX_SIZE_FIELD = new ParseField("max_size", new String[0]);
    public static final ParseField MAX_DOCS_FIELD = new ParseField("max_docs", new String[0]);
    public static final ParseField MAX_AGE_FIELD = new ParseField("max_age", new String[0]);
    public static final String LIFECYCLE_ROLLOVER_ALIAS = "index.lifecycle.rollover_alias";
    public static final Setting<String> LIFECYCLE_ROLLOVER_ALIAS_SETTING = Setting.simpleString((String)"index.lifecycle.rollover_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    private static final ConstructingObjectParser<RolloverAction, Void> PARSER = new ConstructingObjectParser("rollover", a -> new RolloverAction((ByteSizeValue)a[0], (TimeValue)a[1], (Long)a[2]));
    private final ByteSizeValue maxSize;
    private final Long maxDocs;
    private final TimeValue maxAge;

    public static RolloverAction parse(XContentParser parser) {
        return (RolloverAction)PARSER.apply(parser, null);
    }

    public RolloverAction(ByteSizeValue maxSize, TimeValue maxAge, Long maxDocs) {
        if (maxSize == null && maxAge == null && maxDocs == null) {
            throw new IllegalArgumentException("At least one rollover condition must be set.");
        }
        this.maxSize = maxSize;
        this.maxAge = maxAge;
        this.maxDocs = maxDocs;
    }

    public RolloverAction(StreamInput in) throws IOException {
        this.maxSize = in.readBoolean() ? new ByteSizeValue(in) : null;
        this.maxAge = in.readOptionalTimeValue();
        this.maxDocs = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        boolean hasMaxSize = this.maxSize != null;
        out.writeBoolean(hasMaxSize);
        if (hasMaxSize) {
            this.maxSize.writeTo(out);
        }
        out.writeOptionalTimeValue(this.maxAge);
        boolean hasMaxDocs = this.maxDocs != null;
        out.writeBoolean(hasMaxDocs);
        if (hasMaxDocs) {
            out.writeVLong(this.maxDocs.longValue());
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    public ByteSizeValue getMaxSize() {
        return this.maxSize;
    }

    public TimeValue getMaxAge() {
        return this.maxAge;
    }

    public Long getMaxDocs() {
        return this.maxDocs;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxSize != null) {
            builder.field(MAX_SIZE_FIELD.getPreferredName(), this.maxSize.getStringRep());
        }
        if (this.maxAge != null) {
            builder.field(MAX_AGE_FIELD.getPreferredName(), this.maxAge.getStringRep());
        }
        if (this.maxDocs != null) {
            builder.field(MAX_DOCS_FIELD.getPreferredName(), this.maxDocs);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Settings indexingComplete = Settings.builder().put("index.lifecycle.indexing_complete", true).build();
        Step.StepKey waitForRolloverReadyStepKey = new Step.StepKey(phase, NAME, "check-rollover-ready");
        Step.StepKey rolloverStepKey = new Step.StepKey(phase, NAME, "attempt-rollover");
        Step.StepKey updateDateStepKey = new Step.StepKey(phase, NAME, "update-rollover-lifecycle-date");
        Step.StepKey setIndexingCompleteStepKey = new Step.StepKey(phase, NAME, INDEXING_COMPLETE_STEP_NAME);
        WaitForRolloverReadyStep waitForRolloverReadyStep = new WaitForRolloverReadyStep(waitForRolloverReadyStepKey, rolloverStepKey, client, this.maxSize, this.maxAge, this.maxDocs);
        RolloverStep rolloverStep = new RolloverStep(rolloverStepKey, updateDateStepKey, client);
        UpdateRolloverLifecycleDateStep updateDateStep = new UpdateRolloverLifecycleDateStep(updateDateStepKey, setIndexingCompleteStepKey, System::currentTimeMillis);
        UpdateSettingsStep setIndexingCompleteStep = new UpdateSettingsStep(setIndexingCompleteStepKey, nextStepKey, client, indexingComplete);
        return Arrays.asList(waitForRolloverReadyStep, rolloverStep, updateDateStep, setIndexingCompleteStep);
    }

    public int hashCode() {
        return Objects.hash(this.maxSize, this.maxAge, this.maxDocs);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RolloverAction other = (RolloverAction)obj;
        return Objects.equals(this.maxSize, other.maxSize) && Objects.equals(this.maxAge, other.maxAge) && Objects.equals(this.maxDocs, other.maxDocs);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_SIZE_FIELD.getPreferredName()), MAX_SIZE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)MAX_AGE_FIELD.getPreferredName()), MAX_AGE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MAX_DOCS_FIELD);
    }
}

