/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;

public class ReadOnlyAction
implements LifecycleAction {
    public static final String NAME = "readonly";
    private static final ObjectParser<ReadOnlyAction, Void> PARSER = new ObjectParser("readonly", false, ReadOnlyAction::new);

    public static ReadOnlyAction parse(XContentParser parser) {
        return (ReadOnlyAction)PARSER.apply(parser, null);
    }

    public ReadOnlyAction() {
    }

    public ReadOnlyAction(StreamInput in) {
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey key = new Step.StepKey(phase, NAME, NAME);
        Settings readOnlySettings = Settings.builder().put("index.blocks.write", true).build();
        return Collections.singletonList(new UpdateSettingsStep(key, nextStepKey, client, readOnlySettings));
    }

    public int hashCode() {
        return ReadOnlyAction.class.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

