/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleOriginationDateParser;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public final class InitializePolicyContextStep
extends ClusterStateActionStep {
    public static final String INITIALIZATION_PHASE = "new";
    public static final Step.StepKey KEY = new Step.StepKey("new", "init", "init");
    private static final Logger logger = LogManager.getLogger(InitializePolicyContextStep.class);

    InitializePolicyContextStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetaData indexMetaData = clusterState.getMetaData().index(index);
        if (indexMetaData == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return clusterState;
        }
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetaData);
        if (lifecycleState.getLifecycleDate() != null) {
            return clusterState;
        }
        IndexMetaData.Builder indexMetadataBuilder = IndexMetaData.builder((IndexMetaData)indexMetaData);
        if (IndexLifecycleOriginationDateParser.shouldParseIndexName(indexMetaData.getSettings())) {
            long parsedOriginationDate = IndexLifecycleOriginationDateParser.parseIndexNameAndExtractDate(index.getName());
            indexMetadataBuilder.settingsVersion(indexMetaData.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetaData.getSettings()).put("index.lifecycle.origination_date", parsedOriginationDate).build());
        }
        ClusterState.Builder newClusterStateBuilder = ClusterState.builder((ClusterState)clusterState);
        LifecycleExecutionState.Builder newCustomData = LifecycleExecutionState.builder(lifecycleState);
        newCustomData.setIndexCreationDate(indexMetaData.getCreationDate());
        indexMetadataBuilder.putCustom("ilm", newCustomData.build().asMap());
        newClusterStateBuilder.metaData(MetaData.builder((MetaData)clusterState.getMetaData()).put(indexMetadataBuilder));
        return newClusterStateBuilder.build();
    }
}

