/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public abstract class AsyncRetryDuringSnapshotActionStep
extends AsyncActionStep {
    private final Logger logger = LogManager.getLogger(AsyncRetryDuringSnapshotActionStep.class);

    public AsyncRetryDuringSnapshotActionStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performAction(IndexMetaData indexMetaData, ClusterState currentClusterState, ClusterStateObserver observer, AsyncActionStep.Listener listener) {
        SnapshotExceptionListener snapshotExceptionListener = new SnapshotExceptionListener(indexMetaData.getIndex(), listener, observer);
        this.performDuringNoSnapshot(indexMetaData, currentClusterState, snapshotExceptionListener);
    }

    abstract void performDuringNoSnapshot(IndexMetaData var1, ClusterState var2, AsyncActionStep.Listener var3);

    class NoSnapshotRunningListener
    implements ClusterStateObserver.Listener {
        private final Consumer<ClusterState> reRun;
        private final Consumer<Exception> exceptionConsumer;
        private final ClusterStateObserver observer;
        private final String indexName;

        NoSnapshotRunningListener(ClusterStateObserver observer, String indexName, Consumer<ClusterState> reRun, Consumer<Exception> exceptionConsumer) {
            this.observer = observer;
            this.reRun = reRun;
            this.exceptionConsumer = exceptionConsumer;
            this.indexName = indexName;
        }

        public void onNewClusterState(ClusterState state) {
            try {
                if (this.snapshotInProgress(state)) {
                    this.observer.waitForNextChange((ClusterStateObserver.Listener)this);
                } else {
                    AsyncRetryDuringSnapshotActionStep.this.logger.debug("[{}] retrying ILM step after snapshot has completed", (Object)this.indexName);
                    this.reRun.accept(state);
                }
            }
            catch (Exception e) {
                this.exceptionConsumer.accept(e);
            }
        }

        private boolean snapshotInProgress(ClusterState state) {
            SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)state.custom("snapshots");
            if (snapshotsInProgress == null || snapshotsInProgress.entries().isEmpty()) {
                return false;
            }
            for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
                if (!snapshot.indices().stream().map(IndexId::getName).anyMatch(name -> name.equals(this.indexName))) continue;
                return true;
            }
            return false;
        }

        public void onClusterServiceClose() {
        }

        public void onTimeout(TimeValue timeout) {
            this.exceptionConsumer.accept(new IllegalStateException("step timed out while waiting for snapshots to complete"));
        }
    }

    class SnapshotExceptionListener
    implements AsyncActionStep.Listener {
        private final Index index;
        private final AsyncActionStep.Listener originalListener;
        private final ClusterStateObserver observer;

        SnapshotExceptionListener(Index index, AsyncActionStep.Listener originalListener, ClusterStateObserver observer) {
            this.index = index;
            this.originalListener = originalListener;
            this.observer = observer;
        }

        @Override
        public void onResponse(boolean complete) {
            this.originalListener.onResponse(complete);
        }

        @Override
        public void onFailure(Exception e) {
            if (e instanceof SnapshotInProgressException) {
                try {
                    AsyncRetryDuringSnapshotActionStep.this.logger.debug("[{}] attempted to run ILM step but a snapshot is in progress, step will retry at a later time", (Object)this.index.getName());
                    this.observer.waitForNextChange((ClusterStateObserver.Listener)new NoSnapshotRunningListener(this.observer, this.index.getName(), state -> {
                        IndexMetaData idxMeta = state.metaData().index(this.index);
                        if (idxMeta == null) {
                            this.originalListener.onResponse(true);
                        }
                        AsyncRetryDuringSnapshotActionStep.this.performAction(idxMeta, (ClusterState)state, this.observer, this.originalListener);
                    }, this.originalListener::onFailure), TimeValue.timeValueHours((long)12L));
                }
                catch (Exception secondError) {
                    secondError.addSuppressed(e);
                    this.originalListener.onFailure(secondError);
                }
            } else {
                this.originalListener.onFailure(e);
            }
        }
    }
}

