/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.notifications;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessageFactory;
import org.elasticsearch.xpack.core.common.notifications.Level;
import org.elasticsearch.xpack.core.common.time.TimeUtils;

public abstract class AbstractAuditMessage
implements ToXContentObject {
    public static final ParseField MESSAGE = new ParseField("message", new String[0]);
    public static final ParseField LEVEL = new ParseField("level", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField NODE_NAME = new ParseField("node_name", new String[0]);
    public static final ParseField JOB_TYPE = new ParseField("job_type", new String[0]);
    private final String resourceId;
    private final String message;
    private final Level level;
    private final Date timestamp;
    private final String nodeName;

    protected static final <T extends AbstractAuditMessage> ConstructingObjectParser<T, Void> createParser(String name, AbstractAuditMessageFactory<T> messageFactory, ParseField resourceField) {
        ConstructingObjectParser PARSER = new ConstructingObjectParser(name, true, a -> messageFactory.newMessage((String)a[0], (String)a[1], (Level)((Object)((Object)a[2])), (Date)a[3], (String)a[4]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), resourceField);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MESSAGE);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Level.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, LEVEL, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeField(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NODE_NAME);
        return PARSER;
    }

    protected AbstractAuditMessage(String resourceId, String message, Level level, Date timestamp, String nodeName) {
        this.resourceId = resourceId;
        this.message = Objects.requireNonNull(message);
        this.level = Objects.requireNonNull(level);
        this.timestamp = Objects.requireNonNull(timestamp);
        this.nodeName = nodeName;
    }

    public final String getResourceId() {
        return this.resourceId;
    }

    public final String getMessage() {
        return this.message;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final Date getTimestamp() {
        return this.timestamp;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String jobType;
        builder.startObject();
        if (this.resourceId != null) {
            builder.field(this.getResourceField(), this.resourceId);
        }
        builder.field(MESSAGE.getPreferredName(), this.message);
        builder.field(LEVEL.getPreferredName(), (Object)this.level);
        builder.field(TIMESTAMP.getPreferredName(), this.timestamp.getTime());
        if (this.nodeName != null) {
            builder.field(NODE_NAME.getPreferredName(), this.nodeName);
        }
        if ((jobType = this.getJobType()) != null) {
            builder.field(JOB_TYPE.getPreferredName(), jobType);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceId, this.message, this.level, this.timestamp, this.nodeName, this.getJobType()});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractAuditMessage)) {
            return false;
        }
        AbstractAuditMessage other = (AbstractAuditMessage)obj;
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.message, other.message) && Objects.equals((Object)this.level, (Object)other.level) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.getJobType(), other.getJobType());
    }

    public abstract String getJobType();

    protected abstract String getResourceField();
}

