/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.license.GetBasicStatusRequest;
import org.elasticsearch.license.GetBasicStatusResponse;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetBasicStatusAction
extends TransportMasterNodeReadAction<GetBasicStatusRequest, GetBasicStatusResponse> {
    @Inject
    public TransportGetBasicStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/license/basic_status", transportService, clusterService, threadPool, actionFilters, GetBasicStatusRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetBasicStatusResponse read(StreamInput in) throws IOException {
        return new GetBasicStatusResponse(in);
    }

    protected void masterOperation(GetBasicStatusRequest request, ClusterState state, ActionListener<GetBasicStatusResponse> listener) throws Exception {
        LicensesMetaData licensesMetaData = (LicensesMetaData)state.metaData().custom("licenses");
        if (licensesMetaData == null) {
            listener.onResponse((Object)new GetBasicStatusResponse(true));
        } else {
            License license = licensesMetaData.getLicense();
            listener.onResponse((Object)new GetBasicStatusResponse(license == null || !license.type().equals("basic")));
        }
    }

    protected ClusterBlockException checkBlock(GetBasicStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

