/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.PostStartTrialRequest;
import org.elasticsearch.license.PostStartTrialResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestPostStartTrialLicense
extends XPackRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestPostStartTrialLicense.class));

    RestPostStartTrialLicense(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_license/start_trial", (RestHandler)this, RestRequest.Method.POST, URI_BASE + "/license/start_trial", deprecationLogger);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        final PostStartTrialRequest startTrialRequest = new PostStartTrialRequest();
        startTrialRequest.setType(request.param("type", "trial"));
        startTrialRequest.acknowledge(request.paramAsBoolean("acknowledge", false));
        return channel -> client.licensing().postStartTrial(startTrialRequest, (ActionListener<PostStartTrialResponse>)new RestBuilderListener<PostStartTrialResponse>(channel){

            public RestResponse buildResponse(PostStartTrialResponse response, XContentBuilder builder) throws Exception {
                PostStartTrialResponse.Status status = response.getStatus();
                builder.startObject();
                builder.field("acknowledged", startTrialRequest.isAcknowledged());
                if (status.isTrialStarted()) {
                    builder.field("trial_was_started", true);
                    builder.field("type", startTrialRequest.getType());
                } else {
                    builder.field("trial_was_started", false);
                    builder.field("error_message", status.getErrorMessage());
                }
                Map<String, String[]> acknowledgementMessages = response.getAcknowledgementMessages();
                if (!acknowledgementMessages.isEmpty()) {
                    builder.startObject("acknowledge");
                    builder.field("message", response.getAcknowledgementMessage());
                    for (Map.Entry<String, String[]> entry : acknowledgementMessages.entrySet()) {
                        builder.startArray(entry.getKey());
                        for (String message : entry.getValue()) {
                            builder.value(message);
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(status.getRestStatus(), builder);
            }
        });
    }

    public String getName() {
        return "post_start_trial";
    }
}

