/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.IOException;
import java.text.ParseException;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Base32 {
    private static final char[] BASE32_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();

    private Base32() {
    }

    public static String encode(String data) {
        Validator.ensureNotNull(data);
        return Base32.encode(StaticUtils.getBytes(data));
    }

    public static String encode(byte[] data) {
        Validator.ensureNotNull(data);
        StringBuilder buffer = new StringBuilder(4 * data.length / 3 + 1);
        Base32.encodeInternal(data, 0, data.length, buffer);
        return buffer.toString();
    }

    public static void encode(String data, StringBuilder buffer) {
        Validator.ensureNotNull(data);
        Base32.encode(StaticUtils.getBytes(data), buffer);
    }

    public static void encode(String data, ByteStringBuffer buffer) {
        Validator.ensureNotNull(data);
        Base32.encode(StaticUtils.getBytes(data), buffer);
    }

    public static void encode(byte[] data, StringBuilder buffer) {
        Base32.encodeInternal(data, 0, data.length, buffer);
    }

    public static void encode(byte[] data, int off, int length, StringBuilder buffer) {
        Base32.encodeInternal(data, off, length, buffer);
    }

    public static void encode(byte[] data, ByteStringBuffer buffer) {
        Base32.encodeInternal(data, 0, data.length, buffer);
    }

    public static void encode(byte[] data, int off, int length, ByteStringBuffer buffer) {
        Base32.encodeInternal(data, off, length, buffer);
    }

    private static void encodeInternal(byte[] data, int off, int length, Appendable buffer) {
        Validator.ensureNotNull(data);
        Validator.ensureTrue(data.length >= off);
        Validator.ensureTrue(data.length >= off + length);
        if (length == 0) {
            return;
        }
        try {
            int pos = off;
            for (int i = 0; i < length / 5; ++i) {
                long longValue = ((long)data[pos++] & 0xFFL) << 32 | ((long)data[pos++] & 0xFFL) << 24 | ((long)data[pos++] & 0xFFL) << 16 | ((long)data[pos++] & 0xFFL) << 8 | (long)data[pos++] & 0xFFL;
                buffer.append(BASE32_ALPHABET[(int)(longValue >> 35 & 0x1FL)]);
                buffer.append(BASE32_ALPHABET[(int)(longValue >> 30 & 0x1FL)]);
                buffer.append(BASE32_ALPHABET[(int)(longValue >> 25 & 0x1FL)]);
                buffer.append(BASE32_ALPHABET[(int)(longValue >> 20 & 0x1FL)]);
                buffer.append(BASE32_ALPHABET[(int)(longValue >> 15 & 0x1FL)]);
                buffer.append(BASE32_ALPHABET[(int)(longValue >> 10 & 0x1FL)]);
                buffer.append(BASE32_ALPHABET[(int)(longValue >> 5 & 0x1FL)]);
                buffer.append(BASE32_ALPHABET[(int)(longValue & 0x1FL)]);
            }
            switch (off + length - pos) {
                case 1: {
                    long longValue = ((long)data[pos] & 0xFFL) << 32;
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 35 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 30 & 0x1FL)]);
                    buffer.append("======");
                    return;
                }
                case 2: {
                    long longValue = ((long)data[pos++] & 0xFFL) << 32 | ((long)data[pos] & 0xFFL) << 24;
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 35 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 30 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 25 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 20 & 0x1FL)]);
                    buffer.append("====");
                    return;
                }
                case 3: {
                    long longValue = ((long)data[pos++] & 0xFFL) << 32 | ((long)data[pos++] & 0xFFL) << 24 | ((long)data[pos] & 0xFFL) << 16;
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 35 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 30 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 25 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 20 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 15 & 0x1FL)]);
                    buffer.append("===");
                    return;
                }
                case 4: {
                    long longValue = ((long)data[pos++] & 0xFFL) << 32 | ((long)data[pos++] & 0xFFL) << 24 | ((long)data[pos++] & 0xFFL) << 16 | ((long)data[pos] & 0xFFL) << 8;
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 35 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 30 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 25 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 20 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 15 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 10 & 0x1FL)]);
                    buffer.append(BASE32_ALPHABET[(int)(longValue >> 5 & 0x1FL)]);
                    buffer.append("=");
                    return;
                }
            }
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new RuntimeException(ioe.getMessage(), ioe);
        }
    }

    public static byte[] decode(String data) throws ParseException {
        Validator.ensureNotNull(data);
        int length = data.length();
        if (length == 0) {
            return StaticUtils.NO_BYTES;
        }
        if (length % 8 != 0) {
            throw new ParseException(UtilityMessages.ERR_BASE32_DECODE_INVALID_LENGTH.get(), length);
        }
        ByteStringBuffer buffer = new ByteStringBuffer(5 * (length / 8));
        int stringPos = 0;
        while (stringPos < length) {
            long longValue = 0L;
            block42: for (int i = 0; i < 8; ++i) {
                longValue <<= 5;
                switch (data.charAt(stringPos++)) {
                    case 'A': 
                    case 'a': {
                        longValue |= 0L;
                        continue block42;
                    }
                    case 'B': 
                    case 'b': {
                        longValue |= 1L;
                        continue block42;
                    }
                    case 'C': 
                    case 'c': {
                        longValue |= 2L;
                        continue block42;
                    }
                    case 'D': 
                    case 'd': {
                        longValue |= 3L;
                        continue block42;
                    }
                    case 'E': 
                    case 'e': {
                        longValue |= 4L;
                        continue block42;
                    }
                    case 'F': 
                    case 'f': {
                        longValue |= 5L;
                        continue block42;
                    }
                    case 'G': 
                    case 'g': {
                        longValue |= 6L;
                        continue block42;
                    }
                    case 'H': 
                    case 'h': {
                        longValue |= 7L;
                        continue block42;
                    }
                    case 'I': 
                    case 'i': {
                        longValue |= 8L;
                        continue block42;
                    }
                    case 'J': 
                    case 'j': {
                        longValue |= 9L;
                        continue block42;
                    }
                    case 'K': 
                    case 'k': {
                        longValue |= 0xAL;
                        continue block42;
                    }
                    case 'L': 
                    case 'l': {
                        longValue |= 0xBL;
                        continue block42;
                    }
                    case 'M': 
                    case 'm': {
                        longValue |= 0xCL;
                        continue block42;
                    }
                    case 'N': 
                    case 'n': {
                        longValue |= 0xDL;
                        continue block42;
                    }
                    case 'O': 
                    case 'o': {
                        longValue |= 0xEL;
                        continue block42;
                    }
                    case 'P': 
                    case 'p': {
                        longValue |= 0xFL;
                        continue block42;
                    }
                    case 'Q': 
                    case 'q': {
                        longValue |= 0x10L;
                        continue block42;
                    }
                    case 'R': 
                    case 'r': {
                        longValue |= 0x11L;
                        continue block42;
                    }
                    case 'S': 
                    case 's': {
                        longValue |= 0x12L;
                        continue block42;
                    }
                    case 'T': 
                    case 't': {
                        longValue |= 0x13L;
                        continue block42;
                    }
                    case 'U': 
                    case 'u': {
                        longValue |= 0x14L;
                        continue block42;
                    }
                    case 'V': 
                    case 'v': {
                        longValue |= 0x15L;
                        continue block42;
                    }
                    case 'W': 
                    case 'w': {
                        longValue |= 0x16L;
                        continue block42;
                    }
                    case 'X': 
                    case 'x': {
                        longValue |= 0x17L;
                        continue block42;
                    }
                    case 'Y': 
                    case 'y': {
                        longValue |= 0x18L;
                        continue block42;
                    }
                    case 'Z': 
                    case 'z': {
                        longValue |= 0x19L;
                        continue block42;
                    }
                    case '2': {
                        longValue |= 0x1AL;
                        continue block42;
                    }
                    case '3': {
                        longValue |= 0x1BL;
                        continue block42;
                    }
                    case '4': {
                        longValue |= 0x1CL;
                        continue block42;
                    }
                    case '5': {
                        longValue |= 0x1DL;
                        continue block42;
                    }
                    case '6': {
                        longValue |= 0x1EL;
                        continue block42;
                    }
                    case '7': {
                        longValue |= 0x1FL;
                        continue block42;
                    }
                    case '=': {
                        switch (length - stringPos) {
                            case 0: {
                                buffer.append((byte)(longValue >> 32 & 0xFFL));
                                buffer.append((byte)(longValue >> 24 & 0xFFL));
                                buffer.append((byte)(longValue >> 16 & 0xFFL));
                                buffer.append((byte)(longValue >> 8 & 0xFFL));
                                return buffer.toByteArray();
                            }
                            case 2: {
                                buffer.append((byte)((longValue <<= 10) >> 32 & 0xFFL));
                                buffer.append((byte)(longValue >> 24 & 0xFFL));
                                buffer.append((byte)(longValue >> 16 & 0xFFL));
                                return buffer.toByteArray();
                            }
                            case 3: {
                                buffer.append((byte)((longValue <<= 15) >> 32 & 0xFFL));
                                buffer.append((byte)(longValue >> 24 & 0xFFL));
                                return buffer.toByteArray();
                            }
                            case 5: {
                                buffer.append((byte)((longValue <<= 25) >> 32 & 0xFFL));
                                return buffer.toByteArray();
                            }
                        }
                        throw new ParseException(UtilityMessages.ERR_BASE32_DECODE_UNEXPECTED_EQUAL.get(stringPos - 1), stringPos - 1);
                    }
                    default: {
                        throw new ParseException(UtilityMessages.ERR_BASE32_DECODE_UNEXPECTED_CHAR.get(Character.valueOf(data.charAt(stringPos - 1))), stringPos - 1);
                    }
                }
            }
            buffer.append((byte)(longValue >> 32 & 0xFFL));
            buffer.append((byte)(longValue >> 24 & 0xFFL));
            buffer.append((byte)(longValue >> 16 & 0xFFL));
            buffer.append((byte)(longValue >> 8 & 0xFFL));
            buffer.append((byte)(longValue & 0xFFL));
        }
        return buffer.toByteArray();
    }

    public static String decodeToString(String data) throws ParseException {
        Validator.ensureNotNull(data);
        byte[] decodedBytes = Base32.decode(data);
        return StaticUtils.toUTF8String(decodedBytes);
    }
}

