/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.xpack.vectors.query.VectorDVAtomicFieldData;

public class VectorDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexFieldData<VectorDVAtomicFieldData> {
    private final boolean isDense;

    public VectorDVIndexFieldData(Index index, String fieldName, boolean isDense) {
        super(index, fieldName);
        this.isDense = isDense;
    }

    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("can't sort on the vector field");
    }

    public VectorDVAtomicFieldData load(LeafReaderContext context) {
        return new VectorDVAtomicFieldData(context.reader(), this.fieldName, this.isDense);
    }

    public VectorDVAtomicFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final boolean isDense;

        public Builder(boolean isDense) {
            this.isDense = isDense;
        }

        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            String fieldName = fieldType.name();
            return new VectorDVIndexFieldData(indexSettings.getIndex(), fieldName, this.isDense);
        }
    }
}

